package com.amity.socialcloud.sdk.api.chat.member

import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipQuery
import com.amity.socialcloud.sdk.api.chat.member.search.AmityChannelMemberSearch
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.chat.domain.channel.participation.AddUsersChannelParticipationUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.member.GetChannelMemberUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.member.GetChannelMembersUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.participation.RemoveUsersChannelParticipationUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class AmityChannelParticipation internal constructor(private val channelId: String) {
    
    /* begin_public_function
	  id: channel.membership.get_my_membership
	  api_style: async
	*/
    fun getMyMembership() : Flowable<AmityChannelMember> {
        return GetChannelMemberUseCase().execute(channelId, AmityCoreClient.getUserId())
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.member.query
	  api_style: live_collection
	*/
    fun getMembers(): AmityChannelMembershipQuery.Builder {
        return AmityChannelMembershipQuery.Builder(channelId)
    }
    /* end_public_function */
    
    fun getMembersFromCache(): Flowable<List<AmityChannelMember>> {
        return GetChannelMembersUseCase().execute(channelId)
    }
    
    /* begin_public_function
	  id: channel.member.search
	  api_style: live_collection
	*/
    fun searchMembers(keyword: String): AmityChannelMemberSearch.Builder {
        return AmityChannelMemberSearch.Builder(channelId, keyword)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.member.add
	*/
    fun addMembers(userIds: List<String>): Completable {
        return AddUsersChannelParticipationUseCase().execute(channelId, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.member.remove
	*/
    fun removeMembers(userIds: List<String>): Completable {
        return RemoveUsersChannelParticipationUseCase().execute(channelId, userIds)
    }
    /* end_public_function */

}