/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.upload;

import com.amity.socialcloud.sdk.infra.upload.AmityErrorUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityUploaderParams;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.core.utils.UtilsKt;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.google.gson.JsonElement;
import io.reactivex.rxjava3.core.Flowable;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u0000 \u0010*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0010B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H$J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityUploadService;", "T", "", "Lcom/amity/socialcloud/sdk/infra/upload/AmityUploaderParams;", "()V", "makeUploadServiceRequest", "Lio/reactivex/rxjava3/core/Flowable;", "parseEkoFileEntity", "Lcom/ekoapp/ekosdk/internal/EkoFileEntity;", "serverResponse", "Lcom/google/gson/JsonElement;", "parseErrorResponse", "Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "error", "", "transfer", "Companion", "amity-sdk_release"})
public abstract class AmityUploadService<T>
implements AmityUploaderParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String UPLOAD_FILE_PATH = "api/v3/files";

    @NotNull
    protected abstract Flowable<T> makeUploadServiceRequest();

    @NotNull
    public final Flowable<T> transfer() {
        return this.makeUploadServiceRequest();
    }

    @NotNull
    protected final EkoFileEntity parseEkoFileEntity(@NotNull JsonElement serverResponse) {
        Intrinsics.checkNotNullParameter((Object)serverResponse, (String)"serverResponse");
        Object object = EkoGson.get().fromJson(serverResponse, EkoFileEntity[].class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get().fromJson(serverRes\u2026oFileEntity>::class.java)");
        List data = ArraysKt.toList((Object[])((Object[])object));
        return (EkoFileEntity)CollectionsKt.first((List)data);
    }

    @NotNull
    protected final AmityException parseErrorResponse(@NotNull Throwable error) {
        AmityException amityException;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (((throwable instanceof UnknownHostException ? true : throwable instanceof ConnectException) ? true : throwable instanceof SocketTimeoutException) ? true : throwable instanceof SocketException) {
            amityException = AmityException.Companion.create$default(AmityException.Companion, "Connection error", null, AmityError.CONNECTION_ERROR, null, 8, null);
        } else {
            String errorResponse = error.getMessage();
            AmityException exception = AmityException.Companion.create$default(AmityException.Companion, "Unknown", null, AmityError.UNKNOWN, null, 8, null);
            try {
                AmityErrorUploadService errorUploadService = (AmityErrorUploadService)EkoGson.get().fromJson(errorResponse, AmityErrorUploadService.class);
                Object object = EkoGson.get().fromJson(errorUploadService.getErrorBody(), SocketResponse.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get().fromJson(errorUplo\u2026cketResponse::class.java)");
                SocketResponse response = (SocketResponse)object;
                exception = AmityException.Companion.create$default(AmityException.Companion, response.getMessage(), null, response.getCode(), null, 8, null);
            }
            catch (Exception parsingException) {
                String string = UtilsKt.getCurrentClassAndMethodNames();
                String string2 = parsingException.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                String trace = string + ", " + string2;
                AmityLog.INSTANCE.e(trace, new Object[0]);
                return exception;
            }
            amityException = exception;
        }
        return amityException;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityUploadService$Companion;", "", "()V", "UPLOAD_FILE_PATH", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

