package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import org.amity.types.ObjectId
import java.util.Objects

@Entity(tableName = "analytics_event")
data class AnalyticsEventEntity(
    @PrimaryKey
    var eventId: String = ObjectId.get().toHexString(),
    var userId: String = "",
    var contentId: String = "",
    var contentType: String = "",
    var activityType: String = "",
    val syncPriority: String = AnalyticsEventSyncPriority.LOW.apiKey
) : EkoObject() {

    override fun getId(): String {
        return eventId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is AnalyticsEventEntity
                && Objects.equals(id, other.id)
                && Objects.equals(userId, other.userId)
                && Objects.equals(contentId, other.contentId)
                && Objects.equals(contentType, other.contentType)
                && Objects.equals(activityType, other.activityType)
                && Objects.equals(syncPriority, other.syncPriority))
    }

    override fun hashCode(): Int {
        return Objects.hash(id, userId, contentId, contentType, activityType)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("id", id)
            add("userId", userId)
            add("contentId", contentId)
            add("contentType", contentType)
            add("activityType", activityType)
            add("syncPriority", syncPriority)
        }
        return super.internalToString(toStringHelper)
    }
}