package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;

import io.reactivex.Flowable;

@Dao
public abstract class EkoCommentFlagDao extends EkoObjectDao<EkoCommentFlagEntity> {

    @Query("DELETE from comment_flag")
    public abstract void deleteAll();

    @Query("SELECT * from comment_flag where commentId = :commentId LIMIT 1")
    abstract EkoCommentFlagEntity getByIdNowImpl(String commentId);

    public EkoCommentFlagEntity getByIdNow(@NonNull String commentId) {
        return getByIdNowImpl(commentId);
    }

    @Query("SELECT *" +
            " from comment_flag" +
            " where comment_flag.commentId = :commentId" +
            " LIMIT 1")
    abstract Flowable<EkoCommentFlagEntity> getByCommentIdImpl(String commentId);

    public Flowable<EkoCommentFlagEntity> getByCommentId(String commentId) {
        return getByCommentIdImpl(commentId);
    }
}


