package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "channel_marker", primaryKeys = ["channelId","userId"])
open class ChannelMarkerEntity : EkoObject() {
    
    var channelId: String = ObjectId.get().toHexString()
    var userId: String = ""
    var unreadCount : Int = 0
    var isDeleted: Boolean = false
    var hasMentioned: Boolean = false

    override fun getId(): String {
        return channelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is ChannelMarkerEntity
                && Objects.equal(channelId, other.channelId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(unreadCount, other.unreadCount)
                && Objects.equal(isDeleted, other.isDeleted)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                && Objects.equal(hasMentioned, other.hasMentioned)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            channelId,
            userId,
            unreadCount,
            isDeleted,
            createdAt,
            updatedAt,
            hasMentioned
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("channelId", channelId)
            add("userId", userId)
            add("unreadCount", unreadCount)
            add("isDeleted", isDeleted)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
            add("hasMentioned", hasMentioned)
        }
        return super.internalToString(toStringHelper)
    }

}