package com.amity.socialcloud.sdk.core.data.user

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto

internal class UserEntityMapper : EntityMapper<EkoUserDto, UserEntity>() {

    override fun map(list: List<EkoUserDto>): List<UserEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoUserDto) : UserEntity {
        return UserEntity().apply {
            this.userId = dto.userId
            this.mid = dto.mid
            this.path = dto.path
            this.displayName = dto.displayName
            this.roles = dto.roles
            this.permissions = dto.permissions
            this.avatarFileId = dto.avatarFileId
            this.avatarCustomUrl = dto.avatarCustomUrl
            this.description = dto.description
            this.flagCount = dto.flagCount
            this.metadata = dto.metadata
            if (dto.isGlobalBan != null) {
                this.isGlobalBan = dto.isGlobalBan ?: false
            }
            if (dto.isDeleted != null) {
                this.isDeleted = dto.isDeleted ?: false
            }
            this.setCreatedAt(dto.createdAt)
            this.setUpdatedAt(dto.updatedAt)
        }
    }

}