package com.amity.socialcloud.sdk.chat.data.channel.paging

import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class MessageDeliveredUsersKeyCreator(
        private val messageId: String,
        private val memberships: List<MessageDeliveredMembershipFilter>,
) : DynamicQueryStreamKeyCreator {
    
    override fun toMap(): Map<String, Any> {
        return mapOf(
            "messageId" to messageId,
            "memberships" to memberships,
        )
    }
    
    override fun getFilterQuery(): String {
        return " true"
    }
}