/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.usecase.stream;

import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity;
import com.ekoapp.ekosdk.AmityNetworkUtils;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoStreamApi;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequest;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequestCreator;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.repository.stream.StreamSessionRepository;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ekoapp/ekosdk/internal/usecase/stream/SendStreamSessionUseCase;", "", "()V", "retryCount", "", "execute", "Lio/reactivex/rxjava3/core/Completable;", "streamSessions", "", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamSessionEntity;", "requireNetwork", "", "getApiKey", "Lio/reactivex/rxjava3/core/Maybe;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "markAsFailed", "", "markAsSynced", "sendToServer", "apiKey", "", "shouldSend", "amity-sdk_release"})
public final class SendStreamSessionUseCase {
    private int retryCount;

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions) {
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        Completable completable = this.getApiKey().flatMapCompletable(new Function(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
            {
                this.this$0 = $receiver;
                this.$streamSessions = $streamSessions;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoApiKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                return (CompletableSource)SendStreamSessionUseCase.access$sendToServer(this.this$0, string, this.$streamSessions);
            }
        }).doOnComplete(() -> SendStreamSessionUseCase.execute$lambda$0(this, streamSessions)).doOnError(new Consumer(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
            {
                this.this$0 = $receiver;
                this.$streamSessions = $streamSessions;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SendStreamSessionUseCase.access$markAsFailed(this.this$0, this.$streamSessions);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun execute(streamSessio\u2026d(streamSessions) }\n    }");
        return completable;
    }

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions, boolean requireNetwork) {
        Completable completable;
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        if (streamSessions.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n                Comple\u2026.complete()\n            }");
        } else if (requireNetwork) {
            Completable completable3 = Flowable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).filter(new Predicate(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(long it) {
                    return SendStreamSessionUseCase.access$shouldSend(this.this$0);
                }
            }).takeUntil(new Predicate(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(long it) {
                    return SendStreamSessionUseCase.access$getRetryCount$p(this.this$0) >= 60;
                }
            }).firstOrError().flatMapCompletable(new Function(this, streamSessions){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
                {
                    this.this$0 = $receiver;
                    this.$streamSessions = $streamSessions;
                }

                @NotNull
                public final CompletableSource apply(long it) {
                    return (CompletableSource)this.this$0.execute(this.$streamSessions);
                }
            });
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"fun execute(streamSessio\u2026        }\n        }\n    }");
        } else {
            completable = this.execute(streamSessions);
        }
        return completable;
    }

    private final boolean shouldSend() {
        boolean bl;
        if (AmityNetworkUtils.Companion.isNetworkAvailable()) {
            bl = true;
        } else {
            int n = this.retryCount;
            this.retryCount = n + 1;
            bl = false;
        }
        return bl;
    }

    private final Maybe<EkoApiKey> getApiKey() {
        Maybe<EkoApiKey> maybe = EkoDatabase.get().apiKeyDao().getCurrentApiKey();
        Intrinsics.checkNotNullExpressionValue(maybe, (String)"get().apiKeyDao().currentApiKey");
        return maybe;
    }

    private final Completable sendToServer(String apiKey, List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSyncing(streamSessions);
        StreamSessionRequest request = new StreamSessionRequestCreator(streamSessions).create();
        Completable completable = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoStreamApi.class)).flatMapCompletable(new Function(apiKey, request){
            final /* synthetic */ String $apiKey;
            final /* synthetic */ StreamSessionRequest $request;
            {
                this.$apiKey = $apiKey;
                this.$request = $request;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoStreamApi it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)it.sendStreamSession(this.$apiKey, this.$request);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"apiKey: String, streamSe\u2026piKey, request)\n        }");
        return completable;
    }

    private final void markAsSynced(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSynced(streamSessions);
    }

    private final void markAsFailed(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsFailed(streamSessions);
    }

    private static final void execute$lambda$0(SendStreamSessionUseCase this$0, List $streamSessions) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$streamSessions, (String)"$streamSessions");
        this$0.markAsSynced($streamSessions);
    }

    public static final /* synthetic */ Completable access$sendToServer(SendStreamSessionUseCase $this, String apiKey, List streamSessions) {
        return $this.sendToServer(apiKey, streamSessions);
    }

    public static final /* synthetic */ void access$markAsFailed(SendStreamSessionUseCase $this, List streamSessions) {
        $this.markAsFailed(streamSessions);
    }

    public static final /* synthetic */ boolean access$shouldSend(SendStreamSessionUseCase $this) {
        return $this.shouldSend();
    }

    public static final /* synthetic */ int access$getRetryCount$p(SendStreamSessionUseCase $this) {
        return $this.retryCount;
    }
}

