/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.analytics;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsLocalDataStore;
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository;
import com.amity.socialcloud.sdk.core.data.analytics.paging.ViewedUsersMediator;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.ekoapp.ekosdk.internal.api.socket.request.AnalyticsEventRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.SendAnalyticsEventsRequest;
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J&\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/core/data/analytics/AnalyticsRepository;", "", "()V", "createAnalyticEvent", "Lcom/ekoapp/ekosdk/internal/entity/AnalyticsEventEntity;", "contentId", "", "contentType", "activityType", "syncPriority", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncPriority;", "createSendAnalyticEventsRequest", "Lcom/ekoapp/ekosdk/internal/api/socket/request/SendAnalyticsEventsRequest;", "entities", "", "deleteAllAnalyticsEvents", "Lio/reactivex/rxjava3/core/Completable;", "getViewedUsers", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "viewableItemType", "Lcom/amity/socialcloud/sdk/model/core/analytics/AmityViewedType;", "viewableItemId", "saveAnalyticEvent", "sendAnalyticsEvents", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAnalyticsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsRepository.kt\ncom/amity/socialcloud/sdk/core/data/analytics/AnalyticsRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n*S KotlinDebug\n*F\n+ 1 AnalyticsRepository.kt\ncom/amity/socialcloud/sdk/core/data/analytics/AnalyticsRepository\n*L\n118#1:133\n118#1:134,3\n*E\n"})
public final class AnalyticsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_ANALYTIC_EVENTS = 1000;

    @NotNull
    public final Completable saveAnalyticEvent(@NotNull String contentId, @NotNull String contentType, @NotNull String activityType, @NotNull AnalyticsEventSyncPriority syncPriority) {
        Intrinsics.checkNotNullParameter((Object)contentId, (String)"contentId");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)activityType, (String)"activityType");
        Intrinsics.checkNotNullParameter((Object)((Object)syncPriority), (String)"syncPriority");
        AnalyticsLocalDataStore localDataStore = new AnalyticsLocalDataStore();
        Completable completable = localDataStore.getAnalyticsEventsCount().map(new Function(localDataStore){
            final /* synthetic */ AnalyticsLocalDataStore $localDataStore;
            {
                this.$localDataStore = $localDataStore;
            }

            public final void apply(int count) {
                if (count >= 1000) {
                    this.$localDataStore.deleteOldestEvent().subscribeOn(Schedulers.io()).subscribe();
                }
            }
        }).map(new Function(this, contentId, contentType, activityType, syncPriority){
            final /* synthetic */ AnalyticsRepository this$0;
            final /* synthetic */ String $contentId;
            final /* synthetic */ String $contentType;
            final /* synthetic */ String $activityType;
            final /* synthetic */ AnalyticsEventSyncPriority $syncPriority;
            {
                this.this$0 = $receiver;
                this.$contentId = $contentId;
                this.$contentType = $contentType;
                this.$activityType = $activityType;
                this.$syncPriority = $syncPriority;
            }

            @NotNull
            public final AnalyticsEventEntity apply(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AnalyticsRepository.access$createAnalyticEvent(this.this$0, this.$contentId, this.$contentType, this.$activityType, this.$syncPriority);
            }
        }).flatMapCompletable(new Function(localDataStore){
            final /* synthetic */ AnalyticsLocalDataStore $localDataStore;
            {
                this.$localDataStore = $localDataStore;
            }

            @NotNull
            public final CompletableSource apply(@NotNull AnalyticsEventEntity event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return (CompletableSource)this.$localDataStore.saveAnalyticsEvents(CollectionsKt.listOf((Object)event));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun saveAnalyticEvent(\n \u2026ent))\n            }\n    }");
        return completable;
    }

    @NotNull
    public final Completable sendAnalyticsEvents(@NotNull AnalyticsEventSyncPriority syncPriority) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncPriority), (String)"syncPriority");
        Completable completable = new AnalyticsLocalDataStore().getAnalyticsEvents(AmityCoreClient.INSTANCE.getUserId(), syncPriority, 1000).flatMap(new Function(this){
            final /* synthetic */ AnalyticsRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends List<AnalyticsEventEntity>> apply(@NotNull List<AnalyticsEventEntity> entities) {
                Single single;
                Intrinsics.checkNotNullParameter(entities, (String)"entities");
                if (!((Collection)entities).isEmpty()) {
                    SendAnalyticsEventsRequest request = AnalyticsRepository.access$createSendAnalyticEventsRequest(this.this$0, entities);
                    single = new AnalyticsRemoteDataStore().sendAnalyticsEvents(request).map(new Function(entities){
                        final /* synthetic */ List<AnalyticsEventEntity> $entities;
                        {
                            this.$entities = $entities;
                        }

                        @NotNull
                        public final List<AnalyticsEventEntity> apply(@NotNull JsonObject it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$entities;
                        }
                    });
                } else {
                    single = Single.just((Object)CollectionsKt.emptyList());
                }
                return (SingleSource)single;
            }
        }).flatMapCompletable((Function)sendAnalyticsEvents.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun sendAnalyticsEvents(\u2026        }\n        }\n    }");
        return completable;
    }

    @NotNull
    public final Completable deleteAllAnalyticsEvents() {
        return new AnalyticsLocalDataStore().deleteAllAnalyticsEvents();
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getViewedUsers(@NotNull AmityViewedType viewableItemType, @NotNull String viewableItemId) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewableItemType), (String)"viewableItemType");
        Intrinsics.checkNotNullParameter((Object)viewableItemId, (String)"viewableItemId");
        QueryStreamPagerCreator pagerCreator2 = new QueryStreamPagerCreator(new PagingConfig(20, 0, false, 0, 0, 0, 58, null), null, new ViewedUsersMediator(viewableItemType, viewableItemId), (Function0)new Function0<PagingSource<Integer, UserEntity>>(viewableItemType, viewableItemId){
            final /* synthetic */ AmityViewedType $viewableItemType;
            final /* synthetic */ String $viewableItemId;
            {
                this.$viewableItemType = $viewableItemType;
                this.$viewableItemId = $viewableItemId;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, UserEntity> invoke() {
                return new AnalyticsLocalDataStore().getViewedUsersPagingSource(this.$viewableItemType, this.$viewableItemId);
            }
        }, new UserModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    private final AnalyticsEventEntity createAnalyticEvent(String contentId, String contentType, String activityType, AnalyticsEventSyncPriority syncPriority) {
        AnalyticsEventEntity analyticsEventEntity;
        AnalyticsEventEntity $this$createAnalyticEvent_u24lambda_u240 = analyticsEventEntity = new AnalyticsEventEntity(null, new SessionLocalDataStore().getActiveUserId(), contentId, contentType, activityType, syncPriority.getApiKey(), 1, null);
        boolean bl = false;
        DateTime currentDate = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        $this$createAnalyticEvent_u24lambda_u240.setCreatedAt(currentDate);
        $this$createAnalyticEvent_u24lambda_u240.setUpdatedAt(currentDate);
        return analyticsEventEntity;
    }

    /*
     * WARNING - void declaration
     */
    private final SendAnalyticsEventsRequest createSendAnalyticEventsRequest(List<AnalyticsEventEntity> entities) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entity;
            AnalyticsEventEntity analyticsEventEntity = (AnalyticsEventEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = entity.getContentId();
            String string2 = entity.getContentType();
            String string3 = entity.getActivityType();
            DateTime dateTime = entity.getCreatedAt();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"entity.createdAt");
            collection.add(new AnalyticsEventRequest(string, string2, string3, dateTime));
        }
        List list2 = (List)destination$iv$iv;
        return new SendAnalyticsEventsRequest(list2);
    }

    public static final /* synthetic */ AnalyticsEventEntity access$createAnalyticEvent(AnalyticsRepository $this, String contentId, String contentType, String activityType, AnalyticsEventSyncPriority syncPriority) {
        return $this.createAnalyticEvent(contentId, contentType, activityType, syncPriority);
    }

    public static final /* synthetic */ SendAnalyticsEventsRequest access$createSendAnalyticEventsRequest(AnalyticsRepository $this, List entities) {
        return $this.createSendAnalyticEventsRequest(entities);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amity/socialcloud/sdk/core/data/analytics/AnalyticsRepository$Companion;", "", "()V", "MAX_ANALYTIC_EVENTS", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

