/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.push;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.push.EkoPushContract;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;
import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import com.github.davidmoten.guavamini.Objects;
import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import org.reactivestreams.Publisher;

public class EkoPushContractImpl
implements EkoPushContract {
    private final String TAG = this.getClass().getName();

    public EkoPushContractImpl() {
        this.initPushService();
    }

    private void initPushService() {
        Flowable.combineLatest((Publisher)this.initFcm().startWithItem(new TokenConfigAndApiKey<Object>(null, null, null)), (Publisher)this.initBaidu().startWithItem(new TokenConfigAndApiKey<Object>(null, null, null)), Pair::new).skip(1L).flatMapCompletable(configPair -> {
            TokenConfigAndApiKey fcmConfig = (TokenConfigAndApiKey)configPair.first;
            String fcmState = "null";
            if (fcmConfig.config != null) {
                fcmState = fcmConfig.config.getState().getApiKey();
            }
            String fcmToken = "null";
            if (fcmConfig.token != null) {
                fcmToken = ((EkoFcmToken)fcmConfig.token).getToken();
            }
            AmityLog.INSTANCE.e("fcm: " + fcmState + " token:" + fcmToken, new Object[0]);
            TokenConfigAndApiKey baiduConfig = (TokenConfigAndApiKey)configPair.second;
            String baiduState = "null";
            if (baiduConfig.config != null) {
                baiduState = baiduConfig.config.getState().getApiKey();
            }
            String baiduToken = "null";
            if (baiduConfig.token != null) {
                baiduToken = ((EkoBaiduToken)baiduConfig.token).getToken();
            }
            AmityLog.INSTANCE.e("baidu: " + baiduState + " token:" + baiduToken, new Object[0]);
            if (fcmConfig.token != null && baiduConfig.token != null) {
                return this.prioritizeFcmToken(fcmConfig, baiduConfig);
            }
            if (fcmConfig.token != null) {
                return this.handleFcmToken(fcmConfig);
            }
            return this.handleBaiduToken(baiduConfig);
        }).subscribeOn(Schedulers.io()).onErrorComplete().subscribe();
    }

    private Flowable<EkoPushConfig> getPushConfig() {
        return EkoDatabase.get().accountDao().getAll().flatMapIterable(accounts -> accounts).distinct(EkoAccount::getUserId).flatMap(account -> EkoDatabase.get().pushConfigDao().getPushConfig(account.getUserId()).distinctUntilChanged(config -> config));
    }

    private static Flowable<EkoApiKey> getApiKey() {
        return EkoDatabase.get().apiKeyDao().getCurrentApiKeyFlowable();
    }

    private Flowable<TokenConfigAndApiKey<EkoFcmToken>> initFcm() {
        return Flowable.combineLatest((Publisher)EkoDatabase.get().fcmTokenDao().getFcmToken().distinctUntilChanged(fcmToken -> fcmToken), this.getPushConfig(), EkoPushContractImpl.getApiKey(), (x$0, x$1, x$2) -> new TokenConfigAndApiKey<Object>(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2));
    }

    private Flowable<TokenConfigAndApiKey<EkoBaiduToken>> initBaidu() {
        return Flowable.combineLatest((Publisher)EkoDatabase.get().baiduTokenDao().getBaiduToken().distinctUntilChanged(baiduToken -> baiduToken), this.getPushConfig(), EkoPushContractImpl.getApiKey(), (x$0, x$1, x$2) -> new TokenConfigAndApiKey<Object>(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2)).filter(tokenConfigAndApiKey -> ((EkoBaiduToken)tokenConfigAndApiKey.token).getUserId() != null && ((EkoBaiduToken)tokenConfigAndApiKey.token).getChannelId() != null);
    }

    private Completable prioritizeFcmToken(TokenConfigAndApiKey<EkoFcmToken> fcmConfig, TokenConfigAndApiKey<EkoBaiduToken> baiduConfig) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)fcmConfig.config.getState()))) {
            RegisterDeviceForPushNotificationRequest registerRequest = RegisterDeviceForPushNotificationRequest.create(fcmConfig.config.getUserId(), fcmConfig.config.getDeviceId(), ((EkoFcmToken)fcmConfig.token).getToken(), Provider.FCM.getApiKey());
            UnregisterDeviceForPushNotificationRequest unregisterRequest = UnregisterDeviceForPushNotificationRequest.create(baiduConfig.config.getUserId(), baiduConfig.config.getDeviceId());
            return AmityHttpClient.Companion.notification().unregisterNotificationToken(baiduConfig.apiKey.getApiKey(), unregisterRequest).ignoreElement().andThen((CompletableSource)AmityHttpClient.Companion.notification().registerNotificationToken(fcmConfig.apiKey.getApiKey(), registerRequest).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().onErrorComplete()).onErrorComplete();
        }
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(fcmConfig.config.getUserId(), fcmConfig.config.getDeviceId());
        AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return AmityHttpClient.Companion.notification().unregisterNotificationToken(fcmConfig.apiKey.getApiKey(), request).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().onErrorComplete();
    }

    private Completable handleFcmToken(TokenConfigAndApiKey<EkoFcmToken> tokenConfigAndApiKey) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)tokenConfigAndApiKey.config.getState()))) {
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId(), ((EkoFcmToken)tokenConfigAndApiKey.token).getToken(), Provider.FCM.getApiKey());
            AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return AmityHttpClient.Companion.notification().registerNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().onErrorComplete();
        }
        String userId = tokenConfigAndApiKey.config.getUserId();
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId());
        AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return AmityHttpClient.Companion.notification().unregisterNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().andThen((CompletableSource)Completable.fromAction(() -> EkoDatabase.get().pushConfigDao().clearUnregisteredPushConfigForUser(userId))).onErrorComplete();
    }

    private Completable handleBaiduToken(TokenConfigAndApiKey<EkoBaiduToken> tokenConfigAndApiKey) {
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)tokenConfigAndApiKey.config.getState()))) {
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId(), new Gson().toJson((Object)new RegisterDeviceForPushNotificationRequest.BaiduToken(((EkoBaiduToken)tokenConfigAndApiKey.token).getToken(), ((EkoBaiduToken)tokenConfigAndApiKey.token).getUserId(), ((EkoBaiduToken)tokenConfigAndApiKey.token).getChannelId())), Provider.BAIDU.apiKey);
            AmityLog.INSTANCE.tag(this.TAG).i(String.format("baidu registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return AmityHttpClient.Companion.notification().registerNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("baidu response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().onErrorComplete();
        }
        UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(tokenConfigAndApiKey.config.getUserId(), tokenConfigAndApiKey.config.getDeviceId());
        AmityLog.INSTANCE.tag(this.TAG).i(String.format("baidu un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
        return AmityHttpClient.Companion.notification().unregisterNotificationToken(tokenConfigAndApiKey.apiKey.getApiKey(), request).doOnSuccess(response -> AmityLog.INSTANCE.tag(this.TAG).i(String.format("baidu response:%s", new Gson().toJson(response)), new Object[0])).ignoreElement().onErrorComplete();
    }

    public Completable insertBaiduApiKey(@NonNull String apiKey) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().insertOrUpdate(new EkoBaiduToken(apiKey)));
    }

    public Completable updateBaiduToken(@Nullable String token, @Nullable String userId, @Nullable String channelId) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().updateToken(token, userId, channelId));
    }

    public Completable insertFcmToken(@NonNull String fcmToken) {
        return Completable.fromAction(() -> EkoDatabase.get().fcmTokenDao().insert(new EkoFcmToken(fcmToken)));
    }

    public Flowable<Boolean> hasRegisteredConfig() {
        return EkoDatabase.get().pushConfigDao().hasRegisteredConfig();
    }

    class TokenConfigAndApiKey<TOKEN> {
        TOKEN token;
        EkoPushConfig config;
        EkoApiKey apiKey;

        TokenConfigAndApiKey(TOKEN token, EkoPushConfig config, EkoApiKey apiKey) {
            this.token = token;
            this.config = config;
            this.apiKey = apiKey;
        }
    }

    static enum Provider {
        FCM("fcm"),
        BAIDU("baidu");

        private final String apiKey;

        private Provider(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return this.apiKey;
        }
    }
}

