/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0007\bJ\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoFileMapper;", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectMapper;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoFileDto;", "Lcom/ekoapp/ekosdk/internal/EkoFileEntity;", "update", "objectOnDisk", "objectToSave", "AttributesComposer", "Companion", "amity-sdk_release"})
public interface EkoFileMapper
extends EkoObjectMapper<EkoFileDto, EkoFileEntity> {
    @NotNull
    public static final Companion Companion = com.ekoapp.ekosdk.internal.api.mapper.EkoFileMapper$Companion.$$INSTANCE;

    @Override
    @NotNull
    public EkoFileEntity update(@NotNull EkoFileEntity var1, @NotNull EkoFileEntity var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoFileMapper$AttributesComposer;", "", "()V", "compose", "Lcom/google/gson/JsonObject;", "dtoAttributes", "status", "", "videoUrl", "Lcom/google/gson/JsonElement;", "amity-sdk_release"})
    public static final class AttributesComposer {
        @NotNull
        public final JsonObject compose(@Nullable JsonObject dtoAttributes, @Nullable String status, @Nullable JsonElement videoUrl) {
            JsonObject attributes = dtoAttributes;
            if (attributes == null) {
                attributes = new JsonObject();
            }
            if (status != null) {
                attributes.addProperty("status", status);
            }
            if (videoUrl != null && Intrinsics.areEqual(videoUrl.getClass(), JsonObject.class)) {
                attributes.add("videoUrl", videoUrl);
            }
            return attributes;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoFileMapper$Companion;", "", "()V", "MAPPER", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoFileMapper;", "getMAPPER", "()Lcom/ekoapp/ekosdk/internal/api/mapper/EkoFileMapper;", "amity-sdk_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final EkoFileMapper MAPPER;

        private Companion() {
        }

        @NotNull
        public final EkoFileMapper getMAPPER() {
            return MAPPER;
        }

        static {
            $$INSTANCE = new Companion();
            MAPPER = new EkoFileMapper(){

                @NotNull
                public EkoFileEntity map(@NotNull EkoFileDto dto) {
                    Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                    EkoFileEntity file = new EkoFileEntity();
                    String string = dto.getFileId();
                    Intrinsics.checkNotNull((Object)string);
                    file.setFileId(string);
                    file.setFileUrl(dto.getFileUrl());
                    file.setType(dto.getType());
                    file.setCreatedAt(dto.getCreatedAt());
                    file.setUpdatedAt(dto.getUpdatedAt());
                    JsonObject attributes = new AttributesComposer().compose(dto.getAttributes(), dto.getStatus(), dto.getVideoUrl());
                    file.setAttributes(attributes);
                    return file;
                }

                @NotNull
                public EkoFileEntity update(@NotNull EkoFileEntity objectOnDisk, @NotNull EkoFileEntity objectToSave) {
                    return DefaultImpls.update(this, objectOnDisk, objectToSave);
                }
            };
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static EkoFileEntity update(@NotNull EkoFileMapper $this, @NotNull EkoFileEntity objectOnDisk, @NotNull EkoFileEntity objectToSave) {
            Intrinsics.checkNotNullParameter((Object)objectOnDisk, (String)"objectOnDisk");
            Intrinsics.checkNotNullParameter((Object)objectToSave, (String)"objectToSave");
            objectOnDisk.setFileUrl(objectToSave.getFileUrl());
            objectOnDisk.setType(objectToSave.getType());
            objectOnDisk.setAttributes(objectToSave.getAttributes());
            objectOnDisk.setCreatedAt(objectToSave.getCreatedAt());
            objectOnDisk.setUpdatedAt(objectToSave.getUpdatedAt());
            return objectOnDisk;
        }
    }
}

