/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.http.request;

import android.util.Base64;
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSession;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ekoapp/ekosdk/internal/api/http/request/StreamSessionRequestCreator;", "", "streamSessionEntityList", "", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamSessionEntity;", "(Ljava/util/List;)V", "composeUnsignedString", "", "nonceString", "timeStampString", "dataString", "create", "Lcom/ekoapp/ekosdk/internal/api/http/request/StreamSessionRequest;", "createDataString", "streamSessionList", "Lcom/ekoapp/ekosdk/internal/api/http/request/StreamSession;", "createSignature", "plainText", "generateNonceString", "getPrivateKey", "Ljava/security/PrivateKey;", "getSecretKey", "getStreamSessionList", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nStreamSessionRequestCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamSessionRequestCreator.kt\ncom/ekoapp/ekosdk/internal/api/http/request/StreamSessionRequestCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1855#2,2:152\n1045#2:154\n1864#2,3:155\n*S KotlinDebug\n*F\n+ 1 StreamSessionRequestCreator.kt\ncom/ekoapp/ekosdk/internal/api/http/request/StreamSessionRequestCreator\n*L\n30#1:152,2\n39#1:154\n45#1:155,3\n*E\n"})
public final class StreamSessionRequestCreator {
    @NotNull
    private final List<EkoStreamSessionEntity> streamSessionEntityList;

    public StreamSessionRequestCreator(@NotNull List<EkoStreamSessionEntity> streamSessionEntityList) {
        Intrinsics.checkNotNullParameter(streamSessionEntityList, (String)"streamSessionEntityList");
        this.streamSessionEntityList = streamSessionEntityList;
    }

    @NotNull
    public final StreamSessionRequest create() {
        List<StreamSession> steamSessionList = this.getStreamSessionList();
        String nonceString = this.generateNonceString();
        String string = DateTime.now().withZone(DateTimeZone.UTC).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now().withZone(DateTimeZone.UTC).toString()");
        String timeStampString = string;
        String dataString = this.createDataString(steamSessionList);
        String unsignedString = this.composeUnsignedString(nonceString, timeStampString, dataString);
        String signedString = this.createSignature(unsignedString);
        StreamSessionRequest streamSessionRequest = StreamSessionRequest.create(signedString, nonceString, timeStampString, steamSessionList);
        Intrinsics.checkNotNullExpressionValue((Object)streamSessionRequest, (String)"create(signedString, non\u2026String, steamSessionList)");
        return streamSessionRequest;
    }

    private final List<StreamSession> getStreamSessionList() {
        ArrayList<StreamSession> steamSessionList = new ArrayList<StreamSession>();
        Iterable $this$forEach$iv = this.streamSessionEntityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String endTime;
            EkoStreamSessionEntity entity = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            DateTime dateTime = entity.getStartTime();
            String startTime = dateTime != null && (dateTime = dateTime.withZone(DateTimeZone.UTC)) != null && (dateTime = dateTime.toDateTimeISO()) != null ? dateTime.toString() : null;
            DateTime dateTime2 = entity.getEndTime();
            String string = dateTime2 != null && (dateTime2 = dateTime2.withZone(DateTimeZone.UTC)) != null ? dateTime2.toString() : (endTime = null);
            if (startTime == null || endTime == null) continue;
            StreamSession streamSession = StreamSession.create(entity.getSessionId(), entity.getStreamId(), startTime, endTime, entity.getWatchSeconds(), entity.getResolution());
            steamSessionList.add(streamSession);
        }
        Iterable $this$sortedBy$iv = steamSessionList;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StreamSession it = (StreamSession)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getStartTime());
                it = (StreamSession)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getStartTime())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String createDataString(List<? extends StreamSession> streamSessionList) {
        StringBuilder accumulatedSting = new StringBuilder();
        Iterable $this$forEachIndexed$iv = streamSessionList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void streamSession;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StreamSession streamSession2 = (StreamSession)item$iv;
            int index = n;
            boolean bl = false;
            boolean isLastIndex = index == streamSessionList.size() - 1;
            StringBuilder sessionStringData = new StringBuilder().append("endTime=" + streamSession.getEndTime() + '&').append("resolution=" + streamSession.getResolution() + '&').append("sessionId=" + streamSession.getSessionId() + '&').append("startTime=" + streamSession.getStartTime() + '&').append("streamId=" + streamSession.getStreamId() + '&').append("watchSeconds=" + streamSession.getWatchSeconds());
            accumulatedSting.append((CharSequence)sessionStringData);
            if (isLastIndex) continue;
            accumulatedSting.append(";");
        }
        String string = accumulatedSting.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"accumulatedSting.toString()");
        return string;
    }

    private final String composeUnsignedString(String nonceString, String timeStampString, String dataString) {
        String string = "nonceStr=" + nonceString + '&' + ("timestamp=" + timeStampString + '&') + ("data=" + dataString + "==");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().append(\"\u2026              .toString()");
        return string;
    }

    private final String createSignature(String plainText) throws Exception {
        Signature privateSignature = Signature.getInstance("SHA256withRSA");
        privateSignature.initSign(this.getPrivateKey());
        String string = plainText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        privateSignature.update(byArray);
        byte[] signature = privateSignature.sign();
        String string2 = Base64.encodeToString((byte[])signature, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(signature, Base64.DEFAULT)");
        return StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private final PrivateKey getPrivateKey() {
        byte[] byArray = Base64.decode((String)this.getSecretKey(), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(getSecretKey(), Base64.DEFAULT)");
        byte[] keyBytes = byArray;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory fact = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = fact.generatePrivate(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"fact.generatePrivate(keySpec)");
        return privateKey;
    }

    private final String generateNonceString() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    private final String getSecretKey() {
        return Intrinsics.areEqual((Object)EkoEndpoint.INSTANCE.getHttpUrl(), (Object)"https://api.staging.amity.co/") || Intrinsics.areEqual((Object)EkoEndpoint.INSTANCE.getHttpUrl(), (Object)"https://api.dev.amity.co/") ? "MIIEpQIBAAKCAQEAwAEc/oZgYIvKSUG/C3mONYLR4ZPgAjMEX4bJ+xqqakUDRtql\nNO+eZs2blQ1Ko0DBkqPExyQezvjibH5W2UZBV5RaBTlTcNVKTToMBEGesAfaEcM3\nqUyQHxdbFYZv6P4sb14dcwxTQ8usmaV8ooiR1Fcaso5ZWYcZ8Hb46FbQ7OoVumsB\ntPWwfZ4f003o5VCl6AIM6lcLv9UDLlFVYhE+PeXpRHtfWlGqxMvqC9oinlwhL6nW\nv6VjQXW4nhcib72dPBzfHT7k/PMKto2SxALYdb68ENiAGuJLWi3AUHSyYCJK2w7w\nIlWfJUAI0v26ub10IpExr6D5QuW2577jjP93iwIDAQABAoIBAFWfqXhwIIatkFY+\n9Z1+ZcbDQimgsmMIsUiQaX6Lk7e0cxOj6czDlxYtVtaPiNtow2pLkjNkjkCqiP7t\nEHnwdK9DvylZOTa2R15NJpK3WLcTqVIGhsn/FL5owfvFah6zSsmXZParZm5zY9NZ\nE03ALZhOB9/cz0e3kf/EbpfeL2mW7MApyiUt5i09ycchroOpcWp73ipIxvgigtZy\nUGFmsQicWhUs28F0D7w4Qfk76yG3nqXeb+BAMhCaIaa/k/aAxhiZG/ygEQWQrcC8\ngfe+jyicMAQPDEVS9YuUMGsLjIjKuVLZzp2xirQnhc2i2zVNEIvG6soprPOBEMQu\ngzrtX5ECgYEA3b7KAbBIbDl1e4ZSCWhHdHkiWVZHaopsR/LhqDDNhXjWjq3AesgV\n6k0j9EdziMn/HmmOso0bz99GTV3JZf4A9ztTLumJlkHbdVtlgOqSjrFLj12rH9KX\nTheyIhWSpUmm8+WB1xasFbqpvJaGo7F3pd2Fqj1XR4mp5BO7c/t7LJ0CgYEA3aou\nEzXQ9THRKYocdfY69EI1Il1t/d/RSqqd9BxEjxBgxkM13ZiYIn/R4WW/nCUrlmhx\nG44Aa2Gob4Ahfsui2xKTg/g/3Zk/rAxAEGkfOLGoenaJMD41fH4wUq3FRYwkvnaM\nb9Hd6f/TlBHslIRa2NN58bSBGJCyBP2b59+2+EcCgYEAixDVRXvV37GlYUOa/XVd\nosk5Zoe6oDGRuQm0xbNdoUBoZvDHDvme7ONWEiQha/8qtVsD+CyQ7awcPfb8kK9c\n0bBt+bTS6d4BkTcxkEkMgtrkBVR8Nqfu5jXsLH4VCv4G61zbMhZw8+ut+az5YX2y\nCN7Frj9sFlxapMRPQmzMEe0CgYEAumsAzM8ZqNv4mAK65Mnr0rhLj1cbxcKRdUYA\nCOgtEFQpzxN/HZnTeFAe5nx3pI3uFlRHq3DFEYnT6dHMWaJQmAULYpVIwMi9L6gt\nyJ9fzoI6uqMtxRDMUqKdaSsTGOY/kJ6KhQ/unXi1K3XXjR+yd1+C0q+HUm1+CYxv\nrZYLfskCgYEArsEy+IQOiqniJ0NE2vVUF+UK/IRZaic9YKcpov5Ot7Vvzm/MnnW4\nN1ljVskocETBWMmPUvNSExVjPebi+rxd8fa5kY8BJScPTzMFbunZn/wjtGdcM10q\ndlVQ9doG61A/9P3ezFKCfS4AvF/H/59LcSx2Bh28fp3/efiVIOpVd4Y=" : "MIIEowIBAAKCAQEAx6PNEnnB+xbhdoRWJ2/pduv1TfFDC1wEBS58XIjUxMJBlRTK\nXXs5R/K1Nh7VCS+ERE6IGwDi1WNFzI7OrD5/BtZwC5ofang6VLVahTlbQR8RGfdd\nEyzrUIrp46iSjuZ1name9RAtzhZbkYhkJDvOAYiBW79+7m+8Zd0vF2q27SqC3Mla\nZAx4vtcMdaYAgJ+oLQVIHJDy+TUfIy7Hmm5dxwF0H4UwiqOLZjhTNg8cJdSFDJiC\nayYP2iFP1NLY/9RKKO5htCXDVl9fZVtxHnAm4tJ3AiTq5FHcJQa3I2jGsml/7mxM\nMlHkxoi3cnOC9xkSx48ivMYFTV0TB22VidmuTQIDAQABAoIBAEsbhPt+c0xTv18n\nSoJryBnFi/RW4DJV2+1XH9JwaBveOW4s9DVXNqWq2iISV3OtPMW2Bd6i5rQBNTFQ\nSNDkckXQRzcWNNuJf+h+kh+tBHfriDOMrKeaLq2OlY/gy8KXUYiPWA46mAEAyFJo\nTcST+1z4TjKGSOrLfsWUATN+InP27wDEiZvTmaYUqd/ql1ZBWc7a9psQ9hGUiSS2\nMYvAQnYDNqoWs2pW3CeswyhwmVlVpvEUcQxpXcjG/9t+ycRE8z+NLQJczmQ5gQG1\nIBJ7qwyfd0VQyBN622VLIcIHkHdfGnptPeploLwdQCCmILEwEd6cPldfWFgI6v4J\nT+n8/MECgYEA/6EKvrpChdD0YAXjOYHk40sLHRqaUC5n+Z3bo76Is/06XYwxD7uk\nfJIoEK9axtreCv8n3WaCPEXZiQ9Wpd0OzfYaH6KEsuK4+hN7cc1mQhyYx2ndnJwq\nfztuh4kXhgJe8E3H05jXYhR4WUM5uSQZL1gIsLr0DDXxG518cOv7yA8CgYEAx+31\n/ILHO+yS7wFoKdTGkDf7G6lW+iXk9RUH0fBP1hQkps0AbTc3eSoGLgnnpcK//A8m\nMrbzdgcwmGV6e94CNYxd2JVuY1Z++DmOk8ENPeXYoMKOmdMrsaKXSDgKSoAJC/T0\nSoDa6gH9zQMjLmupThon84w6IwtylH8pUJsTJ+MCgYB6dgfTvx9HRAcOSUPFtPiV\n+slkM+5hIxokdv9Vvl12/IUNc6+9PcNa+hm/hIIUaZ2d3waWBhm2DjBcfMChzPje\nqltxdEXl/L9o7hRhPGkUmuaGAa1s7VNeiHY27/IY/OHGdTyZncrw7aWJ/a6VhzmZ\neK8RGz726pCLDjMjVanU+QKBgDkoHpsCCFNpXthVXqIW4m14k6Fk2CjLjJlEWef6\n+9gICjJliSmwD3vkN8ARtNf+xUQaUKFPDGtBwvLOkCW5YohMiMfScKyVndb5HXnA\nRzja7QOIm5v+cw9lnDpZSxfhYrS4Yt6p1+vuhdCGhRhQTya085b9D+HU8/zgHb+d\nlexhAoGBANk7bTigQKlpZYDmmTpKpS1TCVZoEe7OrS4tfnBD/GXGqVfWkW0c0wCl\n5uH/ABIbZRvRfZAjrx2AmBouiWoliWZB43nsd0/nhOg4usuQZvyH7eY7VYSeIwlc\nBzikzHo+/TT1BUyX7/IQqNvYWgQ7+kVxa7/k9tSgnMPJN7CXiVlk";
    }
}

