/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.marker.subchannel;

import com.amity.socialcloud.sdk.chat.data.marker.reader.MarkReadRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ReCalculateChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.subchannel.GetSubChannelUnreadCountUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0006J\u0014\u0010\u0014\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0014\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\fJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository;", "", "()V", "deleteUnreadInfoByChannelId", "", "channelId", "", "deleteUnreadInfoBySubChannelId", "subChannelId", "fetchSubChannelMarker", "Lio/reactivex/rxjava3/core/Completable;", "subChannelIds", "", "fetchSubChannelUnreadInfo", "channelIds", "getSubChannelMarker", "Lcom/ekoapp/ekosdk/internal/UserSubChannelMarkerEntity;", "getSubChannelUnreadInfo", "Lcom/ekoapp/ekosdk/internal/SubChannelUnreadInfoEntity;", "getUserSubChannelMarker", "readSubChannels", "saveSubChannelUnreadInfo", "unreadInfo", "startSubChannelReading", "stopSubChannelReading", "updateReadToSegment", "segment", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubChannelMarkerRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubChannelMarkerRepository.kt\ncom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n1855#2,2:107\n*S KotlinDebug\n*F\n+ 1 SubChannelMarkerRepository.kt\ncom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository\n*L\n89#1:103\n89#1:104,3\n90#1:107,2\n*E\n"})
public final class SubChannelMarkerRepository {
    @NotNull
    public final Completable fetchSubChannelMarker(@NotNull List<String> subChannelIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(subChannelIds, (String)"subChannelIds");
        if (!CoreClient.INSTANCE.isUnreadCountEnable() || subChannelIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completable.complete()\n        }");
        } else {
            Completable completable3 = new SubChannelMarkerRemoteDataStore().querySubChannelMarkers(subChannelIds).flatMapCompletable((Function)fetchSubChannelMarker.1.INSTANCE);
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n            SubChannel\u2026              }\n        }");
        }
        return completable;
    }

    @Nullable
    public final UserSubChannelMarkerEntity getSubChannelMarker(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new GetSubChannelUnreadCountUseCase().execute(subChannelId);
    }

    public final void updateReadToSegment(@NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelMarkerLocalDataStore().updateReadToSegment(subChannelId, segment);
    }

    @Nullable
    public final UserSubChannelMarkerEntity getUserSubChannelMarker(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new SubChannelMarkerLocalDataStore().getUserSubChannelMarker(subChannelId);
    }

    @NotNull
    public final Completable startSubChannelReading(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = new MarkReadRemoteDataStore().startSubChannelReading(subChannelId).flatMapCompletable((Function)startSubChannelReading.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MarkReadRemoteDataStore(\u2026hedulers.Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable readSubChannels(@NotNull List<String> subChannelIds) {
        Intrinsics.checkNotNullParameter(subChannelIds, (String)"subChannelIds");
        Completable completable = new MarkReadRemoteDataStore().readSubChannel(subChannelIds).flatMapCompletable((Function)readSubChannels.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MarkReadRemoteDataStore(\u2026hedulers.Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable stopSubChannelReading(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = new MarkReadRemoteDataStore().stopSubChannelReading(subChannelId).flatMapCompletable((Function)stopSubChannelReading.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MarkReadRemoteDataStore(\u2026hedulers.Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable fetchSubChannelUnreadInfo(@NotNull List<String> channelIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        if (CoreClient.INSTANCE.isUnreadCountEnable()) {
            Completable completable2 = new SubChannelMarkerRemoteDataStore().queryUserSubChannelMarkers(channelIds).flatMapCompletable((Function)fetchSubChannelUnreadInfo.1.INSTANCE).subscribeOn(Schedulers.io());
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            SubChannel\u2026chedulers.io())\n        }");
        } else {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n            Completable.complete()\n        }");
        }
        return completable;
    }

    @Nullable
    public final SubChannelUnreadInfoEntity getSubChannelUnreadInfo(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new SubChannelMarkerLocalDataStore().getSubChannelUnreadInfo(subChannelId);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSubChannelUnreadInfo(@NotNull List<? extends SubChannelUnreadInfoEntity> unreadInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(unreadInfo, (String)"unreadInfo");
        new SubChannelMarkerLocalDataStore().saveSubChannelUnreadInfo(unreadInfo);
        Iterable $this$map$iv = unreadInfo;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SubChannelUnreadInfoEntity subChannelUnreadInfoEntity = (SubChannelUnreadInfoEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        List channelIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = channelIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String channelId = (String)element$iv;
            boolean bl = false;
            new ReCalculateChannelUnreadInfoUseCase().execute(channelId);
        }
    }

    public final void deleteUnreadInfoBySubChannelId(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelMarkerLocalDataStore().deleteUnreadInfoBySubChannelId(subChannelId);
    }

    public final void deleteUnreadInfoByChannelId(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        new SubChannelMarkerLocalDataStore().deleteUnreadInfoByChannelId(channelId);
    }
}

