/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.data.dao.ChannelUnreadInfoDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ChannelUnreadInfoDao_Impl
extends ChannelUnreadInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelUnreadInfoEntity> __insertionAdapterOfChannelUnreadInfoEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChannelUnreadInfoEntity> __deletionAdapterOfChannelUnreadInfoEntity;
    private final EntityDeletionOrUpdateAdapter<ChannelUnreadInfoEntity> __updateAdapterOfChannelUnreadInfoEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public ChannelUnreadInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelUnreadInfoEntity = new EntityInsertionAdapter<ChannelUnreadInfoEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_unread_info` (`channelId`,`unreadCount`,`isMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadInfoEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                int _tmp = value.isMentioned() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                String _tmp_1 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfChannelUnreadInfoEntity = new EntityDeletionOrUpdateAdapter<ChannelUnreadInfoEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_unread_info` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadInfoEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelUnreadInfoEntity = new EntityDeletionOrUpdateAdapter<ChannelUnreadInfoEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_unread_info` SET `channelId` = ?,`unreadCount` = ?,`isMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadInfoEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                int _tmp = value.isMentioned() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                String _tmp_1 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_unread_info";
                return "DELETE from channel_unread_info";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_unread_info where channelId = ?";
                return "DELETE from channel_unread_info where channelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(ChannelUnreadInfoEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelUnreadInfoEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ChannelUnreadInfoEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelUnreadInfoEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChannelUnreadInfoEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelUnreadInfoEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ChannelUnreadInfoEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelUnreadInfoEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ChannelUnreadInfoEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChannelUnreadInfoEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChannelUnreadInfoEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadInfoDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ChannelUnreadInfoEntity> objects) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadInfoDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ChannelUnreadInfoEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadInfoDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    @Override
    public Flowable<ChannelUnreadInfoEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_unread_info where channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_unread_info where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread_info"}, (Callable)new Callable<ChannelUnreadInfoEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelUnreadInfoEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChannelUnreadInfoDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChannelUnreadInfoEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
                    int _cursorIndexOfIsMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMentioned");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChannelUnreadInfoEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                        _result.setUnreadCount(_tmpUnreadCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsMentioned);
                        boolean _tmpIsMentioned = _tmp != 0;
                        _result.setMentioned(_tmpIsMentioned);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ChannelUnreadInfoEntity channelUnreadInfoEntity = _result;
                    return channelUnreadInfoEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelUnreadInfoEntity getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from channel_unread_info where channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_unread_info where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ChannelUnreadInfoEntity _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
            int _cursorIndexOfIsMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMentioned");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new ChannelUnreadInfoEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                _result.setUnreadCount(_tmpUnreadCount);
                int _tmp = _cursor.getInt(_cursorIndexOfIsMentioned);
                boolean _tmpIsMentioned = _tmp != 0;
                _result.setMentioned(_tmpIsMentioned);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            ChannelUnreadInfoEntity channelUnreadInfoEntity = _result;
            return channelUnreadInfoEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

