/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import co.amity.rxbridge.SingleKt;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J*\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ,\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "ABOUT_TO_EXPIRE_TRESHOLD", "", "activateAccount", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "userId", "", "clearData", "Lio/reactivex/rxjava3/core/Completable;", "getActiveUserId", "getCurrentAccount", "login", "displayName", "authToken", "isLegacyVersion", "", "logout", "renewToken", "account", "renewTokenIfNeed", "updateDisplayNameIfNeeded", "", "verifyCurrentAccessToken", "amity-sdk_release"})
public final class SessionRepository
extends EkoObjectRepository {
    private final double ABOUT_TO_EXPIRE_TRESHOLD;

    public SessionRepository() {
        this.ABOUT_TO_EXPIRE_TRESHOLD = 0.8;
    }

    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = this.activateAccount(userId).flatMapCompletable(new Function(this, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, it, this.$displayName, this.$authToken, this.$isLegacyVersion);
            }
        }).doOnComplete(() -> SessionRepository.login$lambda$0(this, userId, displayName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun login(\n        userI\u2026Name)\n            }\n    }");
        return completable;
    }

    @NotNull
    public final Completable logout() {
        return new DeviceNotificationRepository().unregisterAll();
    }

    @NotNull
    public final Completable clearData() {
        Completable completable = Completable.fromAction(SessionRepository::clearData$lambda$1).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Single<EkoAccount> getCurrentAccount() {
        Single single = Single.create(SessionRepository::getCurrentAccount$lambda$2).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"create {\n            val\u2026scribeOn(Schedulers.io())");
        return single;
    }

    @NotNull
    public final Completable renewToken(@NotNull EkoAccount account, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account, displayName, authToken, isLegacyVersion, this){
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            final /* synthetic */ SessionRepository this$0;
            {
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoApiKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                String string = it.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                String string2 = this.$account.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"account.userId");
                String string3 = this.$account.getDeviceId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"account.deviceId");
                io.reactivex.Single single = SingleKt.toRx2(sessionRemoteDataStore.registerDevice(string, string2, this.$displayName, string3, this.$authToken, this.$isLegacyVersion)).retryWhen(RetryWhen.retryIf(renewToken.1::apply$lambda$0).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build());
                Intrinsics.checkNotNullExpressionValue((Object)single, (String)"SessionRemoteDataStore()\u2026d()\n                    )");
                return (CompletableSource)SingleKt.toRx3((io.reactivex.Single)single).flatMapCompletable(new Function(this.$account, this.$isLegacyVersion, this.this$0){
                    final /* synthetic */ EkoAccount $account;
                    final /* synthetic */ boolean $isLegacyVersion;
                    final /* synthetic */ SessionRepository this$0;
                    {
                        this.$account = $account;
                        this.$isLegacyVersion = $isLegacyVersion;
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull RegisterDeviceDto it) {
                        EkoUserListDto ekoUserListDto;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$account.setRefreshToken(it.getRefreshToken());
                        this.$account.setAccessToken(it.getAccessToken());
                        if (this.$isLegacyVersion) {
                            this.$account.setIssuedAt(DateTime.now());
                            this.$account.setExpiresAt(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L)));
                        } else {
                            this.$account.setIssuedAt(it.getIssuedAt());
                            this.$account.setExpiresAt(it.getExpiresAt());
                        }
                        double tokenDuration = (double)(this.$account.getExpiresAt().getMillis() - this.$account.getIssuedAt().getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * SessionRepository.access$getABOUT_TO_EXPIRE_TRESHOLD$p(this.this$0);
                        this.$account.setAboutToExpireAt(this.$account.getIssuedAt().plus((long)tokenDuration));
                        Object[] objectArray = new Object[]{"token renewed: account updated : \n       expiresAt = " + this.$account.getExpiresAt() + " \naboutToExpireAt = " + this.$account.getAboutToExpireAt() + "\n       issuedAt = " + this.$account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "};
                        AmityLog.INSTANCE.e("SSM3", objectArray);
                        EkoUserListDto $this$apply_u24lambda_u240 = ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        List list2 = it.getUsers();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setUsers(list2);
                        List list3 = it.getFiles();
                        if (list3 == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setFiles(list3);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                }).doOnError(new Consumer(this.$account){
                    final /* synthetic */ EkoAccount $account;
                    {
                        this.$account = $account;
                    }

                    public final void accept(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
                        String string = this.$account.getUserId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
                        sessionLocalDataStore.logoutAccount(string);
                    }
                });
            }

            private static final boolean apply$lambda$0(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) != AmityError.USER_IS_GLOBAL_BANNED;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun renewToken(\n        \u2026    }\n            }\n    }");
        return completable;
    }

    public static /* synthetic */ Completable renewToken$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sessionRepository.renewToken(ekoAccount, string, string2, bl);
    }

    private final Single<EkoAccount> activateAccount(String userId) {
        Single single = Single.fromCallable(() -> SessionRepository.activateAccount$lambda$3(userId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable {\n         \u2026scribeOn(Schedulers.io())");
        return single;
    }

    private final Completable renewTokenIfNeed(EkoAccount account, String displayName, String authToken, boolean isLegacyVersion) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext(new Function(this, account, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            @NotNull
            public final CompletableSource apply(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)this.this$0.renewToken(this.$account, this.$displayName, this.$authToken, this.$isLegacyVersion);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun renewTokenIf\u2026        }\n        }\n    }");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account){
            final /* synthetic */ EkoAccount $account;
            {
                this.$account = $account;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoApiKey it) {
                CompletableSource completableSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$account.getAccessToken() == null) {
                    completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "accessToken not found", null, AmityError.UNAUTHORIZED_ERROR, null, 8, null));
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                    completableSource = (CompletableSource)sessionRemoteDataStore.verifyAccessToken(string);
                }
                return completableSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"account: EkoAccount): Co\u2026          }\n            }");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observe(userId).firstOrError().flatMapCompletable(new Function(displayName, userId){
                final /* synthetic */ String $displayName;
                final /* synthetic */ String $userId;
                {
                    this.$displayName = $displayName;
                    this.$userId = $userId;
                }

                @NotNull
                public final CompletableSource apply(@NotNull AmityUser it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser(this.$userId, new UserUpdateOption(this.$displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
                }
            }).subscribeOn(Schedulers.io()).doOnError((Consumer)updateDisplayNameIfNeeded.2.INSTANCE).subscribe();
        }
    }

    private static final void login$lambda$0(SessionRepository this$0, String $userId, String $displayName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        this$0.updateDisplayNameIfNeeded($userId, $displayName);
    }

    private static final void clearData$lambda$1() {
        new SessionLocalDataStore().logoutAccount(new SessionLocalDataStore().getActiveUserId());
    }

    private static final void getCurrentAccount$lambda$2(SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EkoAccount account = new SessionLocalDataStore().getCurrentAccount();
        if (account != null) {
            it.onSuccess((Object)account);
        } else {
            it.onError((Throwable)EntityNotFoundException.INSTANCE);
        }
    }

    private static final EkoAccount activateAccount$lambda$3(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        return new SessionLocalDataStore().activateAccount($userId);
    }

    public static final /* synthetic */ Completable access$renewTokenIfNeed(SessionRepository $this, EkoAccount account, String displayName, String authToken, boolean isLegacyVersion) {
        return $this.renewTokenIfNeed(account, displayName, authToken, isLegacyVersion);
    }

    public static final /* synthetic */ double access$getABOUT_TO_EXPIRE_TRESHOLD$p(SessionRepository $this) {
        return $this.ABOUT_TO_EXPIRE_TRESHOLD;
    }
}

