/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.channel;

import com.amity.socialcloud.sdk.api.chat.channel.create.AmityChannelCreationType;
import com.amity.socialcloud.sdk.api.chat.channel.query.AmityChannelQueryType;
import com.amity.socialcloud.sdk.api.chat.channel.update.AmityChannelUpdate;
import com.amity.socialcloud.sdk.api.chat.member.AmityChannelModeration;
import com.amity.socialcloud.sdk.api.chat.member.AmityChannelParticipation;
import com.amity.socialcloud.sdk.api.chat.notification.AmityChannelNotification;
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelLiveObjectUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.GetChannelsUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.JoinChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.LeaveChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.MuteChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.UnMuteChannelUseCase;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000eJ \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/api/chat/channel/AmityChannelRepository;", "", "()V", "createChannel", "Lcom/amity/socialcloud/sdk/api/chat/channel/create/AmityChannelCreationType;", "displayName", "", "editChannel", "Lcom/amity/socialcloud/sdk/api/chat/channel/update/AmityChannelUpdate$Builder;", "channelId", "getChannel", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel;", "getChannels", "Lcom/amity/socialcloud/sdk/api/chat/channel/query/AmityChannelQueryType;", "", "channelIds", "joinChannel", "Lio/reactivex/rxjava3/core/Single;", "leaveChannel", "Lio/reactivex/rxjava3/core/Completable;", "membership", "Lcom/amity/socialcloud/sdk/api/chat/member/AmityChannelParticipation;", "moderation", "Lcom/amity/socialcloud/sdk/api/chat/member/AmityChannelModeration;", "muteChannel", "timeout", "Lorg/joda/time/Duration;", "notification", "Lcom/amity/socialcloud/sdk/api/chat/notification/AmityChannelNotification;", "unmuteChannel", "updateChannel", "amity-sdk_release"})
public final class AmityChannelRepository {
    @NotNull
    public final AmityChannelCreationType createChannel(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return new AmityChannelCreationType(displayName);
    }

    @NotNull
    public final AmityChannelQueryType getChannels() {
        return new AmityChannelQueryType();
    }

    @NotNull
    public final Flowable<AmityChannel> getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new ChannelLiveObjectUseCase().execute(channelId);
    }

    @NotNull
    public final Single<AmityChannel> joinChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new JoinChannelUseCase().execute(channelId);
    }

    @NotNull
    public final Completable leaveChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new LeaveChannelUseCase().execute(channelId);
    }

    @Deprecated(message="This function is deprecated, please use AmityChatClient.newChannelRepository().editChannel() instead", replaceWith=@ReplaceWith(expression="AmityChatClient.newChannelRepository().editChannel()", imports={"com.amity.socialcloud.sdk.api.chat.subchannel.AmityChannelRepository"}))
    @NotNull
    public final AmityChannelUpdate.Builder updateChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelUpdate.Builder(channelId);
    }

    @NotNull
    public final AmityChannelUpdate.Builder editChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelUpdate.Builder(channelId);
    }

    @NotNull
    public final AmityChannelParticipation membership(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelParticipation(channelId);
    }

    @NotNull
    public final AmityChannelModeration moderation(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelModeration(channelId);
    }

    @Deprecated(message="Use AmityCoreClient.notification.channel(channelId: String) instead")
    @NotNull
    public final AmityChannelNotification notification(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new AmityChannelNotification(channelId);
    }

    @NotNull
    public final Completable muteChannel(@NotNull String channelId, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return new MuteChannelUseCase().execute(channelId, timeout);
    }

    @NotNull
    public final Completable unmuteChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new UnMuteChannelUseCase().execute(channelId);
    }

    @NotNull
    public final Flowable<List<AmityChannel>> getChannels(@NotNull List<String> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        return new GetChannelsUseCase().execute(channelIds);
    }
}

