/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.SubChannelEntity;
import com.ekoapp.ekosdk.internal.data.dao.SubChannelDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class SubChannelDao_Impl
extends SubChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SubChannelEntity> __insertionAdapterOfSubChannelEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<SubChannelEntity> __deletionAdapterOfSubChannelEntity;
    private final EntityDeletionOrUpdateAdapter<SubChannelEntity> __updateAdapterOfSubChannelEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMarkerHash;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserMarkerHash;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLastActivity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestMessage;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMessagePreview;
    private final SharedSQLiteStatement __preparedStmtOfNotifyChanges;

    public SubChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSubChannelEntity = new EntityInsertionAdapter<SubChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `sub_channel` (`subChannelId`,`channelId`,`channelPublicId`,`networkId`,`channelType`,`name`,`messageCount`,`isDeleted`,`latestMessageId`,`lastActivity`,`creatorId`,`creatorPublicId`,`path`,`editedAt`,`subChannelMarkerHash`,`userSubChannelMarkerHash`,`messagePreviewId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SubChannelEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getChannelPublicId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getChannelPublicId());
                }
                if (value.getNetworkId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNetworkId());
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getChannelType());
                }
                if (value.getName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getName());
                }
                stmt.bindLong(7, (long)value.getMessageCount());
                int _tmp = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                if (value.getLatestMessageId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getLatestMessageId());
                }
                String _tmp_1 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCreatorId());
                }
                if (value.getCreatorPublicId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getCreatorPublicId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getPath());
                }
                String _tmp_2 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_2);
                }
                stmt.bindLong(15, (long)value.getSubChannelMarkerHash());
                stmt.bindLong(16, (long)value.getUserSubChannelMarkerHash());
                if (value.getMessagePreviewId() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getMessagePreviewId());
                }
                String _tmp_3 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_3);
                }
                String _tmp_4 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_4);
                }
                String _tmp_5 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_5);
                }
            }
        };
        this.__deletionAdapterOfSubChannelEntity = new EntityDeletionOrUpdateAdapter<SubChannelEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `sub_channel` WHERE `channelId` = ? AND `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SubChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfSubChannelEntity = new EntityDeletionOrUpdateAdapter<SubChannelEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `sub_channel` SET `subChannelId` = ?,`channelId` = ?,`channelPublicId` = ?,`networkId` = ?,`channelType` = ?,`name` = ?,`messageCount` = ?,`isDeleted` = ?,`latestMessageId` = ?,`lastActivity` = ?,`creatorId` = ?,`creatorPublicId` = ?,`path` = ?,`editedAt` = ?,`subChannelMarkerHash` = ?,`userSubChannelMarkerHash` = ?,`messagePreviewId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ? AND `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SubChannelEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getChannelPublicId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getChannelPublicId());
                }
                if (value.getNetworkId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNetworkId());
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getChannelType());
                }
                if (value.getName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getName());
                }
                stmt.bindLong(7, (long)value.getMessageCount());
                int _tmp = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                if (value.getLatestMessageId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getLatestMessageId());
                }
                String _tmp_1 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCreatorId());
                }
                if (value.getCreatorPublicId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getCreatorPublicId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getPath());
                }
                String _tmp_2 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_2);
                }
                stmt.bindLong(15, (long)value.getSubChannelMarkerHash());
                stmt.bindLong(16, (long)value.getUserSubChannelMarkerHash());
                if (value.getMessagePreviewId() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getMessagePreviewId());
                }
                String _tmp_3 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_3);
                }
                String _tmp_4 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_4);
                }
                String _tmp_5 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_5);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getChannelId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getSubChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from sub_channel";
                return "delete from sub_channel";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from sub_channel where subChannelId = ?";
                return "delete from sub_channel where subChannelId = ?";
            }
        };
        this.__preparedStmtOfSoftDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update sub_channel set isDeleted = 1 where subChannelId = ? ";
                return "update sub_channel set isDeleted = 1 where subChannelId = ? ";
            }
        };
        this.__preparedStmtOfUpdateMarkerHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set subChannelMarkerHash = ? where subChannelId = ?";
                return "UPDATE sub_channel set subChannelMarkerHash = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateUserMarkerHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set userSubChannelMarkerHash = ? where subChannelId = ?";
                return "UPDATE sub_channel set userSubChannelMarkerHash = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateLastActivity = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set lastActivity = ? where subChannelId = ?";
                return "UPDATE sub_channel set lastActivity = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateLatestMessage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set latestMessageId = ? where subChannelId = ?";
                return "UPDATE sub_channel set latestMessageId = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateMessagePreview = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set messagePreviewId = ? where subChannelId = ?";
                return "UPDATE sub_channel set messagePreviewId = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfNotifyChanges = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE sub_channel set subChannelId = ? where subChannelId = ?";
                return "UPDATE sub_channel set subChannelId = ? where subChannelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(SubChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSubChannelEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends SubChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSubChannelEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(SubChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfSubChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends SubChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfSubChannelEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(SubChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfSubChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(SubChannelEntity object) {
        this.__db.beginTransaction();
        try {
            SubChannelDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends SubChannelEntity> objects) {
        this.__db.beginTransaction();
        try {
            SubChannelDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(SubChannelEntity object) {
        this.__db.beginTransaction();
        try {
            SubChannelDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable deleteById(final String subChanelId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = SubChannelDao_Impl.this.__preparedStmtOfDeleteById.acquire();
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, subChanelId);
                }
                SubChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SubChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    SubChannelDao_Impl.this.__db.endTransaction();
                    SubChannelDao_Impl.this.__preparedStmtOfDeleteById.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable softDeleteById(final String subChanelId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = SubChannelDao_Impl.this.__preparedStmtOfSoftDeleteById.acquire();
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, subChanelId);
                }
                SubChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SubChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    SubChannelDao_Impl.this.__db.endTransaction();
                    SubChannelDao_Impl.this.__preparedStmtOfSoftDeleteById.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMarkerHash(String subChannelId, int hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMarkerHash.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMarkerHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserMarkerHash(String subChannelId, int hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserMarkerHash.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserMarkerHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastActivity(String subChannelId, DateTime lastActivity) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLastActivity.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastActivity);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLastActivity.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatestMessage(String subChannelId, String messageId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLatestMessage.acquire();
        int _argIndex = 1;
        if (messageId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, messageId);
        }
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLatestMessage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessagePreview(String subChannelId, String messagePreviewId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMessagePreview.acquire();
        int _argIndex = 1;
        if (messagePreviewId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, messagePreviewId);
        }
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMessagePreview.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChanges(String subChannelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfNotifyChanges.acquire();
        int _argIndex = 1;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfNotifyChanges.release(_stmt);
        }
    }

    @Override
    public Flowable<SubChannelEntity> getSubChannel(String subChanelId) {
        String _sql = "select * from sub_channel where subChannelId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from sub_channel where subChannelId = ?", (int)1);
        int _argIndex = 1;
        if (subChanelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChanelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel"}, (Callable)new Callable<SubChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubChannelEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SubChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SubChannelEntity _result;
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfChannelPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelPublicId");
                    int _cursorIndexOfNetworkId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLatestMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestMessageId");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfCreatorPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorPublicId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelMarkerHash");
                    int _cursorIndexOfUserSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userSubChannelMarkerHash");
                    int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new SubChannelEntity();
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpChannelPublicId = _cursor.isNull(_cursorIndexOfChannelPublicId) ? null : _cursor.getString(_cursorIndexOfChannelPublicId);
                        _result.setChannelPublicId(_tmpChannelPublicId);
                        String _tmpNetworkId = _cursor.isNull(_cursorIndexOfNetworkId) ? null : _cursor.getString(_cursorIndexOfNetworkId);
                        _result.setNetworkId(_tmpNetworkId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _result.setChannelType(_tmpChannelType);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result.setName(_tmpName);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _result.setMessageCount(_tmpMessageCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpLatestMessageId = _cursor.isNull(_cursorIndexOfLatestMessageId) ? null : _cursor.getString(_cursorIndexOfLatestMessageId);
                        _result.setLatestMessageId(_tmpLatestMessageId);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setLastActivity(_tmpLastActivity);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        String _tmpCreatorPublicId = _cursor.isNull(_cursorIndexOfCreatorPublicId) ? null : _cursor.getString(_cursorIndexOfCreatorPublicId);
                        _result.setCreatorPublicId(_tmpCreatorPublicId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmpSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfSubChannelMarkerHash);
                        _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                        int _tmpUserSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfUserSubChannelMarkerHash);
                        _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                        String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                        _result.setMessagePreviewId(_tmpMessagePreviewId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    SubChannelEntity subChannelEntity = _result;
                    return subChannelEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubChannelEntity getByIdNowImpl(String id) {
        String _sql = "select * from sub_channel where subChannelId = ? limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from sub_channel where subChannelId = ? limit 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            SubChannelEntity _result;
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfChannelPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelPublicId");
            int _cursorIndexOfNetworkId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkId");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfLatestMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestMessageId");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfCreatorPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorPublicId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelMarkerHash");
            int _cursorIndexOfUserSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userSubChannelMarkerHash");
            int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new SubChannelEntity();
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpChannelPublicId = _cursor.isNull(_cursorIndexOfChannelPublicId) ? null : _cursor.getString(_cursorIndexOfChannelPublicId);
                _result.setChannelPublicId(_tmpChannelPublicId);
                String _tmpNetworkId = _cursor.isNull(_cursorIndexOfNetworkId) ? null : _cursor.getString(_cursorIndexOfNetworkId);
                _result.setNetworkId(_tmpNetworkId);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _result.setChannelType(_tmpChannelType);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result.setName(_tmpName);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _result.setMessageCount(_tmpMessageCount);
                int _tmp = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmpLatestMessageId = _cursor.isNull(_cursorIndexOfLatestMessageId) ? null : _cursor.getString(_cursorIndexOfLatestMessageId);
                _result.setLatestMessageId(_tmpLatestMessageId);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setLastActivity(_tmpLastActivity);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _result.setCreatorId(_tmpCreatorId);
                String _tmpCreatorPublicId = _cursor.isNull(_cursorIndexOfCreatorPublicId) ? null : _cursor.getString(_cursorIndexOfCreatorPublicId);
                _result.setCreatorPublicId(_tmpCreatorPublicId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setEditedAt(_tmpEditedAt);
                int _tmpSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfSubChannelMarkerHash);
                _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                int _tmpUserSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfUserSubChannelMarkerHash);
                _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                _result.setMessagePreviewId(_tmpMessagePreviewId);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            SubChannelEntity subChannelEntity = _result;
            return subChannelEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<SubChannelEntity>> observeSubChanel(String subChanelId) {
        String _sql = "select * from sub_channel where subChannelId IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from sub_channel where subChannelId IN (?)", (int)1);
        int _argIndex = 1;
        if (subChanelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChanelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel"}, (Callable)new Callable<List<SubChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubChannelEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SubChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfChannelPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelPublicId");
                    int _cursorIndexOfNetworkId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLatestMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestMessageId");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfCreatorPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorPublicId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelMarkerHash");
                    int _cursorIndexOfUserSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userSubChannelMarkerHash");
                    int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<SubChannelEntity> _result = new ArrayList<SubChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        SubChannelEntity _item = new SubChannelEntity();
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _item.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item.setChannelId(_tmpChannelId);
                        String _tmpChannelPublicId = _cursor.isNull(_cursorIndexOfChannelPublicId) ? null : _cursor.getString(_cursorIndexOfChannelPublicId);
                        _item.setChannelPublicId(_tmpChannelPublicId);
                        String _tmpNetworkId = _cursor.isNull(_cursorIndexOfNetworkId) ? null : _cursor.getString(_cursorIndexOfNetworkId);
                        _item.setNetworkId(_tmpNetworkId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _item.setChannelType(_tmpChannelType);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _item.setName(_tmpName);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _item.setMessageCount(_tmpMessageCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp != 0;
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmpLatestMessageId = _cursor.isNull(_cursorIndexOfLatestMessageId) ? null : _cursor.getString(_cursorIndexOfLatestMessageId);
                        _item.setLatestMessageId(_tmpLatestMessageId);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setLastActivity(_tmpLastActivity);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _item.setCreatorId(_tmpCreatorId);
                        String _tmpCreatorPublicId = _cursor.isNull(_cursorIndexOfCreatorPublicId) ? null : _cursor.getString(_cursorIndexOfCreatorPublicId);
                        _item.setCreatorPublicId(_tmpCreatorPublicId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item.setPath(_tmpPath);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setEditedAt(_tmpEditedAt);
                        int _tmpSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfSubChannelMarkerHash);
                        _item.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                        int _tmpUserSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfUserSubChannelMarkerHash);
                        _item.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                        String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                        _item.setMessagePreviewId(_tmpMessagePreviewId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    ArrayList<SubChannelEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<SubChannelEntity> getLatestSubChannelImpl(Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from sub_channel where case when ? is not null then sub_channel.isDeleted = ? else sub_channel.subChannelId is not null end and sub_channel.updatedAt > ? and sub_channel.subChannelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by sub_channel.updatedAt desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from sub_channel where case when ? is not null then sub_channel.isDeleted = ? else sub_channel.subChannelId is not null end and sub_channel.updatedAt > ? and sub_channel.subChannelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by sub_channel.updatedAt desc limit 1", (int)5);
        int _argIndex = 1;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel", "amity_paging_id"}, (Callable)new Callable<SubChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubChannelEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SubChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SubChannelEntity _result;
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfChannelPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelPublicId");
                    int _cursorIndexOfNetworkId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkId");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfLatestMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestMessageId");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfCreatorPublicId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorPublicId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelMarkerHash");
                    int _cursorIndexOfUserSubChannelMarkerHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userSubChannelMarkerHash");
                    int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new SubChannelEntity();
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpChannelPublicId = _cursor.isNull(_cursorIndexOfChannelPublicId) ? null : _cursor.getString(_cursorIndexOfChannelPublicId);
                        _result.setChannelPublicId(_tmpChannelPublicId);
                        String _tmpNetworkId = _cursor.isNull(_cursorIndexOfNetworkId) ? null : _cursor.getString(_cursorIndexOfNetworkId);
                        _result.setNetworkId(_tmpNetworkId);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _result.setChannelType(_tmpChannelType);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result.setName(_tmpName);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _result.setMessageCount(_tmpMessageCount);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpLatestMessageId = _cursor.isNull(_cursorIndexOfLatestMessageId) ? null : _cursor.getString(_cursorIndexOfLatestMessageId);
                        _result.setLatestMessageId(_tmpLatestMessageId);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setLastActivity(_tmpLastActivity);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        String _tmpCreatorPublicId = _cursor.isNull(_cursorIndexOfCreatorPublicId) ? null : _cursor.getString(_cursorIndexOfCreatorPublicId);
                        _result.setCreatorPublicId(_tmpCreatorPublicId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmpSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfSubChannelMarkerHash);
                        _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                        int _tmpUserSubChannelMarkerHash = _cursor.getInt(_cursorIndexOfUserSubChannelMarkerHash);
                        _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                        String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                        _result.setMessagePreviewId(_tmpMessagePreviewId);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = SubChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    SubChannelEntity subChannelEntity = _result;
                    return subChannelEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

