/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.story.create;

import android.net.Uri;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JJ\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JJ\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/story/create/CreateImageStoryUseCase;", "", "()V", "createLocalStory", "Lio/reactivex/rxjava3/core/Completable;", "uniqueId", "", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "fileUri", "Landroid/net/Uri;", "storyItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "metadata", "Lcom/google/gson/JsonObject;", "imageDisplayMode", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryImageDisplayMode;", "createRemoteStory", "fileId", "execute", "publishError", "referenceId", "exception", "Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "uploadFile", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "amity-sdk_release"})
public final class CreateImageStoryUseCase {
    @NotNull
    public final Completable execute(@NotNull String uniqueId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri fileUri, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata, @NotNull AmityStoryImageDisplayMode imageDisplayMode) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)imageDisplayMode), (String)"imageDisplayMode");
        Completable completable = this.createLocalStory(uniqueId, targetType, targetId, fileUri, storyItems, metadata, imageDisplayMode).andThen((CompletableSource)this.uploadFile(uniqueId, fileUri).flatMapCompletable(arg_0 -> CreateImageStoryUseCase.execute$lambda-1(this, uniqueId, targetType, targetId, storyItems, metadata, imageDisplayMode, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"createLocalStory(\n      \u2026              }\n        )");
        return completable;
    }

    public static /* synthetic */ Completable execute$default(CreateImageStoryUseCase createImageStoryUseCase, String string, AmityStory.TargetType targetType, String string2, Uri uri, List list, JsonObject jsonObject, AmityStoryImageDisplayMode amityStoryImageDisplayMode, int n, Object object) {
        if ((n & 1) != 0) {
            string = "LOCAL_" + UUID.randomUUID();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return createImageStoryUseCase.execute(string, targetType, string2, uri, list, jsonObject, amityStoryImageDisplayMode);
    }

    private final Completable publishError(String referenceId, AmityException exception) {
        Completable completable = new StoryRepository().updateStorySyncState(referenceId, AmityStory.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)exception));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StoryRepository().update\u2026letable.error(exception))");
        return completable;
    }

    private final Completable createLocalStory(String uniqueId, AmityStory.TargetType targetType, String targetId, Uri fileUri, List<? extends AmityStoryItem> storyItems, JsonObject metadata, AmityStoryImageDisplayMode imageDisplayMode) {
        FileRepository fileRepository = new FileRepository();
        String string = AmityStory.DataType.IMAGE.getApiKey();
        String string2 = fileUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileUri.toString()");
        Completable completable = fileRepository.createLocalFile(uniqueId, string, string2).andThen((CompletableSource)new StoryRepository().createLocalImageStory(uniqueId, targetType, targetId, storyItems, metadata, imageDisplayMode));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FileRepository().createL\u2026e\n            )\n        )");
        return completable;
    }

    static /* synthetic */ Completable createLocalStory$default(CreateImageStoryUseCase createImageStoryUseCase, String string, AmityStory.TargetType targetType, String string2, Uri uri, List list, JsonObject jsonObject, AmityStoryImageDisplayMode amityStoryImageDisplayMode, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return createImageStoryUseCase.createLocalStory(string, targetType, string2, uri, list, jsonObject, amityStoryImageDisplayMode);
    }

    private final Single<AmityUploadResult<AmityImage>> uploadFile(String referenceId, Uri fileUri) {
        Single single = new FileRepository().uploadImage(referenceId, fileUri).lastOrError();
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"FileRepository().uploadI\u2026i\n        ).lastOrError()");
        return single;
    }

    private final Completable createRemoteStory(String uniqueId, AmityStory.TargetType targetType, String targetId, String fileId, List<? extends AmityStoryItem> storyItems, JsonObject metadata, AmityStoryImageDisplayMode imageDisplayMode) {
        Completable completable = new StoryRepository().createImageStory(uniqueId, targetType, targetId, fileId, storyItems, metadata, imageDisplayMode).andThen((CompletableSource)Completable.defer(() -> CreateImageStoryUseCase.createRemoteStory$lambda-2(uniqueId, targetType, targetId)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StoryRepository().create\u2026)\n            }\n        )");
        return completable;
    }

    static /* synthetic */ Completable createRemoteStory$default(CreateImageStoryUseCase createImageStoryUseCase, String string, AmityStory.TargetType targetType, String string2, String string3, List list, JsonObject jsonObject, AmityStoryImageDisplayMode amityStoryImageDisplayMode, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return createImageStoryUseCase.createRemoteStory(string, targetType, string2, string3, list, jsonObject, amityStoryImageDisplayMode);
    }

    private static final CompletableSource execute$lambda-1$lambda-0(CreateImageStoryUseCase this$0, String $uniqueId, Throwable it) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        if (it instanceof AmityException) {
            completableSource = (CompletableSource)this$0.publishError($uniqueId, (AmityException)it);
        } else {
            AmityException unknownUploadError = AmityException.Companion.create$default(AmityException.Companion, "image file upload error", null, AmityError.UNKNOWN, null, 8, null);
            completableSource = (CompletableSource)this$0.publishError($uniqueId, unknownUploadError);
        }
        return completableSource;
    }

    private static final CompletableSource execute$lambda-1(CreateImageStoryUseCase this$0, String $uniqueId, AmityStory.TargetType $targetType, String $targetId, List $storyItems, JsonObject $metadata, AmityStoryImageDisplayMode $imageDisplayMode, AmityUploadResult uploadResult) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)$targetType), (String)"$targetType");
        Intrinsics.checkNotNullParameter((Object)$targetId, (String)"$targetId");
        Intrinsics.checkNotNullParameter((Object)$storyItems, (String)"$storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)$imageDisplayMode), (String)"$imageDisplayMode");
        AmityUploadResult amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            completableSource = (CompletableSource)this$0.createRemoteStory($uniqueId, $targetType, $targetId, ((AmityImage)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId(), $storyItems, $metadata, $imageDisplayMode).onErrorResumeNext(arg_0 -> CreateImageStoryUseCase.execute$lambda-1$lambda-0(this$0, $uniqueId, arg_0));
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            completableSource = (CompletableSource)this$0.publishError($uniqueId, ((AmityUploadResult.ERROR)uploadResult).getError());
        } else {
            AmityException unknownUploadError = AmityException.Companion.create$default(AmityException.Companion, "image file upload error", null, AmityError.UNKNOWN, null, 8, null);
            completableSource = (CompletableSource)this$0.publishError($uniqueId, unknownUploadError);
        }
        return completableSource;
    }

    private static final CompletableSource createRemoteStory$lambda-2(String $uniqueId, AmityStory.TargetType $targetType, String $targetId) {
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)$targetType), (String)"$targetType");
        Intrinsics.checkNotNullParameter((Object)$targetId, (String)"$targetId");
        return (CompletableSource)new StoryRepository().updateStorySyncState($uniqueId, AmityStory.State.SYNCED).andThen((CompletableSource)new StoryTargetRepository().updateStoryTargetLastStoryExpiresAt($targetType, $targetId, new StoryRepository().getHighestStoryExpiresAt($targetType, $targetId)));
    }
}

