/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.story;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.VideoGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.GetStoryTargetUseCase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/story/StoryComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "()V", "addCreator", "", "story", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "addData", "addStoryItems", "addTarget", "execute", "getImageFileId", "", "rawData", "Lcom/google/gson/JsonObject;", "getThumbnailFileId", "getVideoFileId", "mapStoryItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "rawStoryItems", "Lcom/google/gson/JsonArray;", "amity-sdk_release"})
public final class StoryComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityStory execute(@NotNull AmityStory story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        this.addTarget(story);
        this.addData(story);
        this.addCreator(story);
        this.addStoryItems(story);
        return story;
    }

    private final void addTarget(AmityStory story) {
        story.setTarget$amity_sdk_release(new GetStoryTargetUseCase().execute(story.getTargetType(), story.getTargetId()));
    }

    private final void addData(AmityStory story) {
        switch (WhenMappings.$EnumSwitchMapping$0[story.getDataType().ordinal()]) {
            case 1: {
                String string;
                String string2 = story.getStoryId();
                JsonObject jsonObject = story.getRawData$amity_sdk_release();
                JsonObject jsonObject2 = story.getRawData$amity_sdk_release();
                if ((jsonObject2 != null && (jsonObject2 = jsonObject2.get("imageDisplayMode")) != null ? jsonObject2.getAsString() : (string = null)) == null) {
                    string = "";
                }
                story.setData$amity_sdk_release(new AmityStory.Data.IMAGE(string2, jsonObject, AmityStoryImageDisplayMode.Companion.enumOf(string), new ImageGetUseCase().execute(this.getImageFileId(story.getRawData$amity_sdk_release()))));
                break;
            }
            case 2: {
                story.setData$amity_sdk_release(new AmityStory.Data.VIDEO(story.getStoryId(), story.getRawData$amity_sdk_release(), new ImageGetUseCase().execute(this.getThumbnailFileId(story.getRawData$amity_sdk_release())), new VideoGetUseCase().execute(this.getVideoFileId(story.getRawData$amity_sdk_release()))));
            }
        }
    }

    private final String getImageFileId(JsonObject rawData) {
        String string;
        JsonObject jsonObject = rawData;
        if ((jsonObject != null && (jsonObject = jsonObject.get("fileId")) != null ? jsonObject.getAsString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    private final String getVideoFileId(JsonObject rawData) {
        String string;
        JsonObject jsonObject = rawData;
        if ((jsonObject != null && (jsonObject = jsonObject.getAsJsonObject("videoFileId")) != null && (jsonObject = jsonObject.get("original")) != null ? jsonObject.getAsString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    private final String getThumbnailFileId(JsonObject rawData) {
        String string;
        JsonObject jsonObject = rawData;
        if ((jsonObject != null && (jsonObject = jsonObject.get("thumbnailFileId")) != null ? jsonObject.getAsString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    private final void addStoryItems(AmityStory story) {
        story.setStoryItems$amity_sdk_release(this.mapStoryItems(story.getRawStoryItems$amity_sdk_release()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<AmityStoryItem> mapStoryItems(JsonArray rawStoryItems) {
        List list;
        JsonArray jsonArray = rawStoryItems;
        if (jsonArray != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String string2;
                String string3;
                String string4;
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonObject item = it.getAsJsonObject();
                JsonElement jsonElement2 = item.get("type");
                String itemType = jsonElement2 != null ? jsonElement2.getAsString() : null;
                JsonElement jsonElement3 = item.get("data");
                Object data = jsonElement3 != null ? jsonElement3.getAsJsonObject() : null;
                JsonObject jsonObject = data;
                String string5 = string4 = jsonObject != null && (jsonObject = jsonObject.get("url")) != null ? jsonObject.getAsString() : null;
                if (string5 == null) {
                    string3 = "";
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"data?.get(\"url\")?.asString ?: \"\"");
                    string3 = string4;
                }
                String url = string3;
                JsonObject jsonObject2 = data;
                String string6 = string2 = jsonObject2 != null && (jsonObject2 = jsonObject2.get("customText")) != null ? jsonObject2.getAsString() : null;
                if (string6 == null) {
                    string = "";
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"data?.get(\"customText\")?.asString ?: \"\"");
                    string = string2;
                }
                String customText = string;
                AmityStoryItem storyItem = Intrinsics.areEqual((Object)itemType, (Object)"hyperlink") ? (AmityStoryItem)new AmityStoryItem.HYPERLINK(url, customText) : (AmityStoryItem)AmityStoryItem.UNKNOWN.INSTANCE;
                collection.add(storyItem);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void addCreator(AmityStory story) {
        story.setCreator$amity_sdk_release(new UserGetUseCase().execute(story.getCreatorId()));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityStory.DataType.values().length];
            nArray[AmityStory.DataType.IMAGE.ordinal()] = 1;
            nArray[AmityStory.DataType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

