/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.storytarget;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetDao;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class StoryTargetDao_Impl
extends StoryTargetDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StoryTargetEntity> __insertionAdapterOfStoryTargetEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<StoryTargetEntity> __deletionAdapterOfStoryTargetEntity;
    private final EntityDeletionOrUpdateAdapter<StoryTargetEntity> __updateAdapterOfStoryTargetEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetLastStoryExpiresAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetLastStorySeenExpiresAt;

    public StoryTargetDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStoryTargetEntity = new EntityInsertionAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `storyTarget` (`uniqueId`,`targetId`,`targetType`,`lastStoryExpiresAt`,`lastStorySeenExpiresAt`,`targetUpdatedAt`,`localLastStoryExpiresAt`,`localLastStorySeenExpiresAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStoryExpiresAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStoryExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStorySeenExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfStoryTargetEntity = new EntityDeletionOrUpdateAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `storyTarget` WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfStoryTargetEntity = new EntityDeletionOrUpdateAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `storyTarget` SET `uniqueId` = ?,`targetId` = ?,`targetType` = ?,`lastStoryExpiresAt` = ?,`lastStorySeenExpiresAt` = ?,`targetUpdatedAt` = ?,`localLastStoryExpiresAt` = ?,`localLastStorySeenExpiresAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStoryExpiresAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStoryExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStorySeenExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_7);
                }
                if (value.getUniqueId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getUniqueId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from storyTarget";
                return "delete from storyTarget";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?";
                return "update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetLastStorySeenExpiresAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?";
                return "update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?";
            }
        };
    }

    @Override
    public void insertImpl(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryTargetEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends StoryTargetEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryTargetEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryTargetEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends StoryTargetEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryTargetEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfStoryTargetEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(StoryTargetEntity object) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends StoryTargetEntity> objects) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(StoryTargetEntity object) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable updateStoryTargetLastStoryExpiresAt(final String targetType, final String targetId, final DateTime lastStoryExpiresAt) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(lastStoryExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable updateStoryTargetLastStorySeenExpiresAt(final String targetType, final String targetId, final DateTime lastStorySeenExpiresAt) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStorySeenExpiresAt.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(lastStorySeenExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStorySeenExpiresAt.release(_stmt);
                }
            }
        });
    }

    @Override
    public Flowable<StoryTargetEntity> observeStory(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where uniqueId = ?", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"storyTarget"}, (Callable)new Callable<StoryTargetEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryTargetEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryTargetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryTargetEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
                    int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
                    int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
                    int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
                    int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryTargetEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                        DateTime _tmpLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                        DateTime _tmpLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                        DateTime _tmpTargetUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                        DateTime _tmpLocalLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                        DateTime _tmpLocalLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryTargetEntity storyTargetEntity = _result;
                    return storyTargetEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryTargetEntity getByIdNowImpl(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where uniqueId = ?", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryTargetEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
            int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
            int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
            int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
            int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryTargetEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryTargetEntity storyTargetEntity = _result;
            return storyTargetEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryTargetEntity getStoryTarget(String targetType, String targetId) {
        String _sql = "select * from storyTarget where targetType = ? and targetId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where targetType = ? and targetId = ?", (int)2);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryTargetEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
            int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
            int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
            int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
            int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryTargetEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryTargetEntity storyTargetEntity = _result;
            return storyTargetEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

