/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.engine.analytics;

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncer;", "", "()V", "syncDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "createHighPrioritySyncTimer", "", "createLowPrioritySyncTimer", "deleteAllAnalyticsEvents", "handleSyncError", "error", "", "start", "stop", "syncCapturedEvent", "syncPriority", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncPriority;", "amity-sdk_release"})
public final class AnalyticsEventSyncer {
    @NotNull
    private final CompositeDisposable syncDisposable = new CompositeDisposable();

    public final void start() {
        this.syncDisposable.clear();
        this.createHighPrioritySyncTimer();
        this.createLowPrioritySyncTimer();
    }

    public final void stop() {
        this.syncDisposable.clear();
    }

    public final void deleteAllAnalyticsEvents() {
        new AnalyticsRepository().deleteAllAnalyticsEvents().subscribeOn(Schedulers.io()).doOnError(AnalyticsEventSyncer::deleteAllAnalyticsEvents$lambda-0).subscribe();
    }

    private final void syncCapturedEvent(AnalyticsEventSyncPriority syncPriority) {
        AnalyticsRepository repository = new AnalyticsRepository();
        repository.sendAnalyticsEvents(syncPriority).subscribeOn(Schedulers.io()).doOnComplete(AnalyticsEventSyncer::syncCapturedEvent$lambda-1).doOnError(arg_0 -> AnalyticsEventSyncer.syncCapturedEvent$lambda-2(this, arg_0)).subscribe();
    }

    private final void handleSyncError(Throwable error) {
        if (error instanceof AmityException) {
            Integer n = ((AmityException)error).getHttpStatusCode$amity_sdk_release();
            int n2 = 422;
            if (n != null && n == n2) {
                this.stop();
                this.deleteAllAnalyticsEvents();
            } else {
                IntRange intRange = new IntRange(500, 599);
                Integer n3 = ((AmityException)error).getHttpStatusCode$amity_sdk_release();
                if (n3 != null && intRange.contains(n3.intValue())) {
                    this.stop();
                }
            }
        }
    }

    private final void createHighPrioritySyncTimer() {
        Disposable disposable = Flowable.interval((long)1000L, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(arg_0 -> AnalyticsEventSyncer.createHighPrioritySyncTimer$lambda-3(this, arg_0)).subscribe();
        CompositeDisposable compositeDisposable = this.syncDisposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    private final void createLowPrioritySyncTimer() {
        Disposable disposable = Flowable.interval((long)1000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(arg_0 -> AnalyticsEventSyncer.createLowPrioritySyncTimer$lambda-4(this, arg_0)).subscribe();
        CompositeDisposable compositeDisposable = this.syncDisposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    private static final void deleteAllAnalyticsEvents$lambda-0(Throwable it) {
    }

    private static final void syncCapturedEvent$lambda-1() {
    }

    private static final void syncCapturedEvent$lambda-2(AnalyticsEventSyncer this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleSyncError(it);
    }

    private static final Unit createHighPrioritySyncTimer$lambda-3(AnalyticsEventSyncer this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.syncCapturedEvent(AnalyticsEventSyncPriority.HIGH);
        return Unit.INSTANCE;
    }

    private static final Unit createLowPrioritySyncTimer$lambda-4(AnalyticsEventSyncer this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.syncCapturedEvent(AnalyticsEventSyncPriority.LOW);
        return Unit.INSTANCE;
    }
}

