/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.story;

import android.net.Uri;
import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.social.story.AmityStoryAnalytics;
import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.domain.story.create.CreateImageStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.create.CreateVideoStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.delete.DeleteStoryUseCase;
import com.amity.socialcloud.sdk.social.domain.story.query.GetActiveStoriesUseCase;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.StoryTargetLiveObjectUseCase;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J:\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J,\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/api/social/story/AmityStoryRepository;", "", "()V", "analytics", "Lcom/amity/socialcloud/sdk/api/social/story/AmityStoryAnalytics;", "storyId", "", "createImageStory", "Lio/reactivex/rxjava3/core/Completable;", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "fileUri", "Landroid/net/Uri;", "storyItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "imageDisplayMode", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryImageDisplayMode;", "metadata", "Lcom/google/gson/JsonObject;", "createVideoStory", "getActiveStories", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/story/AmityStorySortOption;", "getStoryTarget", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryTarget;", "hardDeleteStory", "softDeleteStory", "amity-sdk_release"})
public final class AmityStoryRepository {
    @NotNull
    public final Completable createImageStory(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri fileUri, @NotNull List<? extends AmityStoryItem> storyItems, @NotNull AmityStoryImageDisplayMode imageDisplayMode, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)imageDisplayMode), (String)"imageDisplayMode");
        return CreateImageStoryUseCase.execute$default(new CreateImageStoryUseCase(), null, targetType, targetId, fileUri, storyItems, metadata, imageDisplayMode, 1, null);
    }

    public static /* synthetic */ Completable createImageStory$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, Uri uri, List list, AmityStoryImageDisplayMode amityStoryImageDisplayMode, JsonObject jsonObject, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            amityStoryImageDisplayMode = AmityStoryImageDisplayMode.FIT;
        }
        if ((n & 0x20) != 0) {
            jsonObject = null;
        }
        return amityStoryRepository.createImageStory(targetType, string, uri, list, amityStoryImageDisplayMode, jsonObject);
    }

    @NotNull
    public final Completable createVideoStory(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri fileUri, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        return CreateVideoStoryUseCase.execute$default(new CreateVideoStoryUseCase(), null, targetType, targetId, fileUri, storyItems, metadata, 1, null);
    }

    public static /* synthetic */ Completable createVideoStory$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, Uri uri, List list, JsonObject jsonObject, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            jsonObject = null;
        }
        return amityStoryRepository.createVideoStory(targetType, string, uri, list, jsonObject);
    }

    @NotNull
    public final Flowable<AmityStoryTarget> getStoryTarget(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryTargetLiveObjectUseCase().execute(AmityStoryTarget.Companion.generateUniqueId$amity_sdk_release(targetType.getApiKey(), targetId));
    }

    @NotNull
    public final Flowable<PagingData<AmityStory>> getActiveStories(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull AmityStorySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return new GetActiveStoriesUseCase().execute(targetType, targetId, sortOption);
    }

    public static /* synthetic */ Flowable getActiveStories$default(AmityStoryRepository amityStoryRepository, AmityStory.TargetType targetType, String string, AmityStorySortOption amityStorySortOption, int n, Object object) {
        if ((n & 4) != 0) {
            amityStorySortOption = AmityStorySortOption.FIRST_CREATED;
        }
        return amityStoryRepository.getActiveStories(targetType, string, amityStorySortOption);
    }

    @NotNull
    public final Completable softDeleteStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new DeleteStoryUseCase().execute(storyId, false);
    }

    @NotNull
    public final Completable hardDeleteStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new DeleteStoryUseCase().execute(storyId, true);
    }

    @NotNull
    public final AmityStoryAnalytics analytics(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new AmityStoryAnalytics(storyId);
    }
}

