/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.member;

import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipQuery;
import com.amity.socialcloud.sdk.api.chat.member.search.AmityChannelMemberSearch;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.chat.domain.channel.member.GetChannelMemberUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.participation.AddUsersChannelParticipationUseCase;
import com.amity.socialcloud.sdk.chat.domain.channel.participation.RemoveUsersChannelParticipationUseCase;
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/member/AmityChannelParticipation;", "", "channelId", "", "(Ljava/lang/String;)V", "addMembers", "Lio/reactivex/rxjava3/core/Completable;", "userIds", "", "getMembers", "Lcom/amity/socialcloud/sdk/api/chat/member/query/AmityChannelMembershipQuery$Builder;", "getMyMembership", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/chat/member/AmityChannelMember;", "removeMembers", "searchMembers", "Lcom/amity/socialcloud/sdk/api/chat/member/search/AmityChannelMemberSearch$Builder;", "keyword", "amity-sdk_release"})
public final class AmityChannelParticipation {
    @NotNull
    private final String channelId;

    public AmityChannelParticipation(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.channelId = channelId;
    }

    @NotNull
    public final Flowable<AmityChannelMember> getMyMembership() {
        return new GetChannelMemberUseCase().execute(this.channelId, AmityCoreClient.INSTANCE.getUserId());
    }

    @NotNull
    public final AmityChannelMembershipQuery.Builder getMembers() {
        return new AmityChannelMembershipQuery.Builder(this.channelId);
    }

    @NotNull
    public final AmityChannelMemberSearch.Builder searchMembers(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        return new AmityChannelMemberSearch.Builder(this.channelId, keyword);
    }

    @NotNull
    public final Completable addMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new AddUsersChannelParticipationUseCase().execute(this.channelId, userIds);
    }

    @NotNull
    public final Completable removeMembers(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new RemoveUsersChannelParticipationUseCase().execute(this.channelId, userIds);
    }
}

