/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.RoomDatabase;
import com.ekoapp.ekosdk.internal.data.RoomUtil;
import com.google.common.base.Preconditions;

abstract class BaseRoomDatabase
extends RoomDatabase {
    private static final RoomDatabase.Callback NO_CALLBACK = new RoomDatabase.Callback(){};

    BaseRoomDatabase() {
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, boolean allowMainThreadQueries, @Nullable byte[] passphrase) {
        return BaseRoomDatabase.init(context, klass, name, database, allowMainThreadQueries, passphrase, NO_CALLBACK);
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, boolean allowMainThreadQueries, @Nullable byte[] passphrase, @NonNull RoomDatabase.Callback callback) {
        Context appContext = context.getApplicationContext();
        if (database != null) {
            database.close();
        }
        Preconditions.checkNotNull((Object)callback, (Object)"RoomDatabase.Callback is null");
        RoomDatabase.Builder builder = RoomUtil.databaseBuilder(appContext, klass, name, passphrase).addCallback(callback);
        if (allowMainThreadQueries) {
            builder.allowMainThreadQueries();
        }
        return (T)((Object)((BaseRoomDatabase)builder.build()));
    }
}

