/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.presence;

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository;
import com.amity.socialcloud.sdk.core.presence.PresenceConfig;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.presence.AmityChannelPresence;
import com.amity.socialcloud.sdk.model.core.presence.AmityUserPresence;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.usecase.presence.GetPresenceNetworkSettingUseCase;
import com.ekoapp.ekosdk.internal.usecase.presence.GetUserPresencesUseCase;
import com.ekoapp.ekosdk.internal.usecase.presence.SendPresenceHeartbeatUseCase;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.reactivestreams.Publisher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020(H\u0016J\u0016\u0010-\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0002J\u0018\u0010/\u001a\u00020(2\u0006\u0010&\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012H\u0002J\u0018\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012H\u0002J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020(H\u0002J\u0016\u00107\u001a\u00020(2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0002J\u001c\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001d0%2\u0006\u0010&\u001a\u00020\u0012H\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020(H\u0002J\u0012\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0>J\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u001d0>J\b\u0010@\u001a\u00020(H\u0016J\u0010\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020(H\u0002J\b\u0010E\u001a\u00020\rH\u0002J\u0006\u0010F\u001a\u00020;J\b\u0010G\u001a\u00020(H\u0002J\u0006\u0010H\u001a\u00020(J\u0016\u0010I\u001a\u00020(2\u0006\u0010&\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012J\u0016\u0010J\u001a\u00020(2\u0006\u00102\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012J\u0006\u0010K\u001a\u00020(J\u0006\u0010L\u001a\u00020(J\u0016\u0010M\u001a\u00020(2\u0006\u0010&\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012J\u0016\u0010N\u001a\u00020(2\u0006\u00102\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\"\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0016\u001a*\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0011j\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0017`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a*\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u0011j\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0019`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0011j\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0017`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u001b\u001aH\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001e \u001f*\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d0\u001d \u001f*#\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001e \u001f*\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d0\u001d\u0018\u00010\u001c\u00a2\u0006\u0002\b 0\u001c\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010!\u001aH\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\" \u001f*\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001d0\u001d \u001f*#\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\" \u001f*\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001d0\u001d\u0018\u00010\u001c\u00a2\u0006\u0002\b 0\u001c\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "bufferDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "config", "Lcom/amity/socialcloud/sdk/core/presence/PresenceConfig;", "heartbeatDisposable", "isConfigFetching", "", "isReadyToSync", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastFetches", "Ljava/util/HashMap;", "", "Lorg/joda/time/DateTime;", "Lkotlin/collections/HashMap;", "presenceDisposable", "syncedChannelIdsMap", "", "syncedChannelUserIdsMap", "", "syncedUserIdsMap", "syncingChannelPresencePublisher", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "", "Lcom/amity/socialcloud/sdk/model/core/presence/AmityChannelPresence;", "kotlin.jvm.PlatformType", "Lio/reactivex/rxjava3/annotations/NonNull;", "syncingUserPresencePublisher", "Lcom/amity/socialcloud/sdk/model/core/presence/AmityUserPresence;", "userIdsBuffer", "checkChannelType", "Lio/reactivex/rxjava3/core/Single;", "channelId", "createBufferTimer", "", "createHeartbeatTimer", "createPresenceSyncTimer", "createPresenceTimer", "destroy", "emitPresencesToObserver", "presences", "ensureChannelSyncLimit", "viewId", "ensureUserSyncLimit", "userId", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "fetchBufferUserPresence", "fetchUserPresence", "userIds", "getChannelUserIds", "getConfigForHeartbeat", "Lio/reactivex/rxjava3/core/Completable;", "getConfigForPresence", "getSyncingChannelPresence", "Lio/reactivex/rxjava3/core/Flowable;", "getSyncingUserPresence", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "sendHeartbeat", "shouldConfigFetchForPresence", "startHeartbeat", "stopAllSyncingTimer", "stopHeartbeat", "syncChannelPresence", "syncUserPresence", "unsyncAllChannelPresence", "unsyncAllUserPresence", "unsyncChannelPresence", "unsyncUserPresence", "Companion", "amity-sdk_release"})
public final class PresenceSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PresenceConfig config;
    private boolean isConfigFetching;
    @NotNull
    private AtomicBoolean isReadyToSync;
    @NotNull
    private final HashMap<String, Set<String>> syncedUserIdsMap;
    @NotNull
    private final Set<String> userIdsBuffer;
    @NotNull
    private final HashMap<String, DateTime> lastFetches;
    @NotNull
    private final HashMap<String, Set<String>> syncedChannelIdsMap;
    @NotNull
    private final HashMap<String, Set<String>> syncedChannelUserIdsMap;
    private final BehaviorSubject<List<AmityUserPresence>> syncingUserPresencePublisher;
    private final BehaviorSubject<List<AmityChannelPresence>> syncingChannelPresencePublisher;
    @NotNull
    private final CompositeDisposable heartbeatDisposable;
    @NotNull
    private final CompositeDisposable presenceDisposable;
    @NotNull
    private final CompositeDisposable bufferDisposable;
    @NotNull
    private static final String TAG = "AmityPresenceState";
    private static final long INITIAL_DELAY = 500L;

    public PresenceSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.isReadyToSync = new AtomicBoolean(false);
        this.syncedUserIdsMap = new HashMap();
        this.userIdsBuffer = new LinkedHashSet();
        this.lastFetches = new HashMap();
        this.syncedChannelIdsMap = new HashMap();
        this.syncedChannelUserIdsMap = new HashMap();
        this.syncingUserPresencePublisher = BehaviorSubject.create();
        this.syncingChannelPresencePublisher = BehaviorSubject.create();
        this.heartbeatDisposable = new CompositeDisposable();
        this.presenceDisposable = new CompositeDisposable();
        this.bufferDisposable = new CompositeDisposable();
    }

    @NotNull
    public final Completable startHeartbeat() {
        return this.getConfigForHeartbeat();
    }

    public final void stopHeartbeat() {
        this.heartbeatDisposable.clear();
    }

    public final void syncUserPresence(@NotNull String userId, @NotNull String viewId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        this.ensureUserSyncLimit(userId, viewId);
        this.getConfigForPresence();
    }

    public final void unsyncUserPresence(@NotNull String userId, @NotNull String viewId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Set set = this.syncedUserIdsMap.get(userId);
        Set viewIds = set == null ? (Set)new LinkedHashSet() : set;
        viewIds.remove(viewId);
        if (viewIds.size() == 0) {
            this.syncedUserIdsMap.remove(userId);
            this.userIdsBuffer.remove(userId);
        } else {
            ((Map)this.syncedUserIdsMap).put(userId, viewIds);
        }
    }

    public final void unsyncAllUserPresence() {
        this.syncedUserIdsMap.clear();
        this.stopAllSyncingTimer();
    }

    @NotNull
    public final Flowable<List<AmityUserPresence>> getSyncingUserPresence() {
        Flowable flowable = this.syncingUserPresencePublisher.toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"syncingUserPresencePubli\u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    public final void syncChannelPresence(@NotNull String channelId, @NotNull String viewId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        this.ensureChannelSyncLimit(channelId, viewId);
        this.getConfigForPresence();
    }

    public final void unsyncChannelPresence(@NotNull String channelId, @NotNull String viewId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Set set = this.syncedChannelIdsMap.get(channelId);
        Set viewIds = set == null ? (Set)new LinkedHashSet() : set;
        viewIds.remove(viewId);
        if (viewIds.size() == 0) {
            this.syncedChannelIdsMap.remove(channelId);
            this.syncedChannelUserIdsMap.remove(channelId);
            this.getChannelUserIds(channelId).subscribeOn(Schedulers.io()).subscribe(arg_0 -> PresenceSyncEngine.unsyncChannelPresence$lambda-0(this, arg_0), PresenceSyncEngine::unsyncChannelPresence$lambda-1).isDisposed();
        } else {
            ((Map)this.syncedChannelIdsMap).put(channelId, viewIds);
        }
    }

    public final void unsyncAllChannelPresence() {
        this.syncedChannelIdsMap.clear();
        this.syncedChannelUserIdsMap.clear();
        this.stopAllSyncingTimer();
    }

    @NotNull
    public final Flowable<List<AmityChannelPresence>> getSyncingChannelPresence() {
        Flowable flowable = this.syncingChannelPresencePublisher.toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"syncingChannelPresencePu\u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    private final Completable getConfigForHeartbeat() {
        Completable completable = Single.just((Object)(this.config == null ? 1 : 0)).flatMap(arg_0 -> PresenceSyncEngine.getConfigForHeartbeat$lambda-2(this, arg_0)).retryWhen(PresenceSyncEngine::getConfigForHeartbeat$lambda-3).map(arg_0 -> PresenceSyncEngine.getConfigForHeartbeat$lambda-4(this, arg_0)).flatMapCompletable(arg_0 -> PresenceSyncEngine.getConfigForHeartbeat$lambda-5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"just(config == null)\n   \u2026          }\n            }");
        return completable;
    }

    private final void createHeartbeatTimer() {
        block0: {
            this.heartbeatDisposable.clear();
            Object object = this.config;
            if (object == null || (object = ((PresenceConfig)object).getHeartbeatSyncInterval()) == null) break block0;
            long heartbeatSyncInterval = ((Number)object).longValue();
            boolean bl = false;
            Disposable disposable = Flowable.interval((long)0L, (long)heartbeatSyncInterval, (TimeUnit)TimeUnit.MILLISECONDS).map(arg_0 -> PresenceSyncEngine.createHeartbeatTimer$lambda-7$lambda-6(this, arg_0)).subscribeOn(Schedulers.io()).subscribe();
            CompositeDisposable compositeDisposable = this.heartbeatDisposable;
            Disposable p0 = disposable;
            boolean bl2 = false;
            compositeDisposable.add(p0);
        }
    }

    private final void sendHeartbeat() {
        if (!this.isReadyToSync.get()) {
            return;
        }
        new SendPresenceHeartbeatUseCase().execute().subscribeOn(Schedulers.io()).subscribe();
    }

    private final void getConfigForPresence() {
        if (!this.shouldConfigFetchForPresence()) {
            return;
        }
        new GetPresenceNetworkSettingUseCase().execute().subscribeOn(Schedulers.io()).doOnSubscribe(arg_0 -> PresenceSyncEngine.getConfigForPresence$lambda-8(this, arg_0)).subscribe(arg_0 -> PresenceSyncEngine.getConfigForPresence$lambda-9(this, arg_0), arg_0 -> PresenceSyncEngine.getConfigForPresence$lambda-10(this, arg_0)).isDisposed();
    }

    private final boolean shouldConfigFetchForPresence() {
        boolean bl;
        if (this.isConfigFetching) {
            bl = false;
        } else if (this.config != null) {
            if (this.presenceDisposable.size() > 0 && this.bufferDisposable.size() > 0) {
                bl = false;
            } else {
                this.createPresenceSyncTimer();
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private final void createPresenceSyncTimer() {
        PresenceConfig presenceConfig = this.config;
        boolean bl = presenceConfig != null ? presenceConfig.isSyncEnabled() : false;
        if (bl) {
            this.createPresenceTimer();
            this.createBufferTimer();
        } else {
            AmityLog.INSTANCE.tag(TAG).e("Presence sync is not enabled for this network", new Object[0]);
            this.syncingUserPresencePublisher.onNext((Object)CollectionsKt.emptyList());
            this.syncingChannelPresencePublisher.onNext((Object)CollectionsKt.emptyList());
        }
    }

    private final void createPresenceTimer() {
        block0: {
            this.presenceDisposable.clear();
            Object object = this.config;
            if (object == null || (object = ((PresenceConfig)object).getPresenceSyncInterval()) == null) break block0;
            long presenceSyncInterval = ((Number)object).longValue();
            boolean bl = false;
            Disposable disposable = Flowable.interval((long)500L, (long)presenceSyncInterval, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(arg_0 -> PresenceSyncEngine.createPresenceTimer$lambda-14$lambda-12(this, arg_0)).subscribe();
            CompositeDisposable compositeDisposable = this.presenceDisposable;
            Disposable p0 = disposable;
            boolean bl2 = false;
            compositeDisposable.add(p0);
        }
    }

    private final void createBufferTimer() {
        this.bufferDisposable.clear();
        Disposable disposable = Flowable.interval((long)500L, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(arg_0 -> PresenceSyncEngine.createBufferTimer$lambda-15(this, arg_0)).subscribe();
        CompositeDisposable compositeDisposable = this.bufferDisposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchBufferUserPresence() {
        void $this$filterTo$iv$iv;
        if (this.userIdsBuffer.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = this.userIdsBuffer;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean isExpired;
            String userIdBuffer = (String)element$iv$iv;
            boolean bl = false;
            DateTime lastFetch = this.lastFetches.get(userIdBuffer);
            DateTime dateTime = lastFetch;
            boolean bl2 = isExpired = dateTime != null && (dateTime = dateTime.plusSeconds(30)) != null ? dateTime.isBeforeNow() : true;
            if (!(lastFetch == null || isExpired)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredUserIds = (List)destination$iv$iv;
        boolean bl = false;
        this.fetchUserPresence(filteredUserIds);
        this.userIdsBuffer.clear();
    }

    private final void fetchUserPresence(List<String> userIds) {
        if (userIds.isEmpty() || !this.isReadyToSync.get()) {
            return;
        }
        new GetUserPresencesUseCase().execute(CollectionsKt.toList((Iterable)userIds)).subscribeOn(Schedulers.io()).subscribe(arg_0 -> PresenceSyncEngine.fetchUserPresence$lambda-20(this, arg_0), arg_0 -> PresenceSyncEngine.fetchUserPresence$lambda-21(this, arg_0)).isDisposed();
    }

    /*
     * WARNING - void declaration
     */
    private final void emitPresencesToObserver(List<AmityUserPresence> presences) {
        Object element$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Set<String> set = this.syncedUserIdsMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"syncedUserIdsMap.keys");
        Object $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AmityUserPresence it$iv$iv;
            Object v1;
            block7: {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String userId = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = presences;
                for (Object t : iterable2) {
                    AmityUserPresence it = (AmityUserPresence)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)userId)) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            if ((AmityUserPresence)v1 == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List userPresences = (List)destination$iv$iv;
        boolean $i$a$-let-PresenceSyncEngine$emitPresencesToObserver$32 = false;
        if (!((Collection)userPresences).isEmpty()) {
            this.syncingUserPresencePublisher.onNext((Object)userPresences);
        }
        $this$mapNotNull$iv = this.syncedChannelUserIdsMap;
        $i$f$mapNotNull = false;
        Object $i$a$-let-PresenceSyncEngine$emitPresencesToObserver$32 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            AmityChannelPresence it$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            element$iv$iv = element$iv$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Object t = element$iv$iv;
            boolean bl4 = false;
            String channelId = (String)t.getKey();
            Set userIds = (Set)t.getValue();
            Iterable $this$mapNotNull$iv2 = userIds;
            boolean $i$f$mapNotNull2 = false;
            Iterable bl3 = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                AmityUserPresence it$iv$iv2;
                Object v2;
                block8: {
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    boolean bl5 = false;
                    String userId = (String)element$iv$iv2;
                    boolean bl6 = false;
                    Iterable iterable3 = presences;
                    for (Object t2 : iterable3) {
                        AmityUserPresence it = (AmityUserPresence)t2;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)userId)) continue;
                        v2 = t2;
                        break block8;
                    }
                    v2 = null;
                }
                if ((AmityUserPresence)v2 == null) continue;
                boolean bl8 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List userPresences2 = (List)destination$iv$iv2;
            if ((!((Collection)userPresences2).isEmpty() ? new AmityChannelPresence(channelId, userPresences2) : (AmityChannelPresence)null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List channelPresences = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)channelPresences).isEmpty()) {
            this.syncingChannelPresencePublisher.onNext((Object)channelPresences);
        }
    }

    private final void ensureUserSyncLimit(String userId, String viewId) {
        if (this.syncedUserIdsMap.size() >= 20 && !this.syncedUserIdsMap.containsKey(userId)) {
            AmityLog.INSTANCE.tag(TAG).e("Maximum limit reached for syncing users", new Object[0]);
        } else {
            Set set = this.syncedUserIdsMap.get(userId);
            Set viewIds = set == null ? (Set)new LinkedHashSet() : set;
            viewIds.add(viewId);
            ((Map)this.syncedUserIdsMap).put(userId, viewIds);
            this.userIdsBuffer.add(userId);
        }
    }

    private final void ensureChannelSyncLimit(String channelId, String viewId) {
        if (this.syncedChannelIdsMap.size() >= 20 && !this.syncedChannelIdsMap.containsKey(channelId)) {
            AmityLog.INSTANCE.tag(TAG).e("Maximum limit reached for syncing channels", new Object[0]);
        } else {
            this.checkChannelType(channelId).subscribeOn(Schedulers.io()).subscribe(arg_0 -> PresenceSyncEngine.ensureChannelSyncLimit$lambda-30(this, channelId, viewId, arg_0), PresenceSyncEngine::ensureChannelSyncLimit$lambda-31).isDisposed();
        }
    }

    private final Single<Boolean> checkChannelType(String channelId) {
        Single single = new ChannelRepository().getChannel$amity_sdk_release(channelId).subscribeOn(Schedulers.io()).map(PresenceSyncEngine::checkChannelType$lambda-32);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"ChannelRepository().getC\u2026ONVERSATION\n            }");
        return single;
    }

    private final Single<List<String>> getChannelUserIds(String channelId) {
        Single single = new ChannelMembershipRepository().getChannelMembers(channelId).map(PresenceSyncEngine::getChannelUserIds$lambda-34);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"ChannelMembershipReposit\u2026tUserId() }\n            }");
        return single;
    }

    private final void stopAllSyncingTimer() {
        if (this.syncedUserIdsMap.isEmpty() && this.syncedChannelIdsMap.isEmpty()) {
            this.userIdsBuffer.clear();
            this.presenceDisposable.clear();
            this.bufferDisposable.clear();
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.isReadyToSync.set(true);
        } else {
            this.isReadyToSync.set(false);
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToSync.set(true);
    }

    @Override
    public void destroy() {
        this.isReadyToSync.set(false);
        this.stopHeartbeat();
        this.unsyncAllUserPresence();
        this.unsyncAllChannelPresence();
    }

    @Override
    public void handleTokenExpire() {
        this.isReadyToSync.set(false);
    }

    private static final void unsyncChannelPresence$lambda-0(PresenceSyncEngine this$0, List channelUserIds) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Set<String> set = this$0.userIdsBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)channelUserIds, (String)"channelUserIds");
        set.removeAll(CollectionsKt.toSet((Iterable)channelUserIds));
    }

    private static final void unsyncChannelPresence$lambda-1(Throwable it) {
    }

    private static final SingleSource getConfigForHeartbeat$lambda-2(PresenceSyncEngine this$0, Boolean isConfigEmpty) {
        Single single;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isConfigEmpty, (String)"isConfigEmpty");
        if (isConfigEmpty.booleanValue()) {
            single = new GetPresenceNetworkSettingUseCase().execute();
        } else {
            PresenceConfig presenceConfig = this$0.config;
            Intrinsics.checkNotNull((Object)presenceConfig);
            single = Single.just((Object)presenceConfig);
        }
        return (SingleSource)single;
    }

    private static final Publisher getConfigForHeartbeat$lambda-3(Flowable it) {
        return (Publisher)it.delay(PresenceConfig.Companion.getSYNC_CONFIG_RETRY_INTERVAL(), TimeUnit.MILLISECONDS);
    }

    private static final Boolean getConfigForHeartbeat$lambda-4(PresenceSyncEngine this$0, PresenceConfig it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PresenceConfig presenceConfig = this$0.config = it;
        return presenceConfig != null ? presenceConfig.isSyncEnabled() : false;
    }

    private static final CompletableSource getConfigForHeartbeat$lambda-5(PresenceSyncEngine this$0, Boolean isSyncEnabled) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isSyncEnabled, (String)"isSyncEnabled");
        if (isSyncEnabled.booleanValue()) {
            this$0.createHeartbeatTimer();
            completableSource = (CompletableSource)Completable.complete();
        } else {
            completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "Presence sync is not enabled for this network", null, 400300, null, 8, null));
        }
        return completableSource;
    }

    private static final Unit createHeartbeatTimer$lambda-7$lambda-6(PresenceSyncEngine this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sendHeartbeat();
        return Unit.INSTANCE;
    }

    private static final void getConfigForPresence$lambda-8(PresenceSyncEngine this$0, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isConfigFetching = true;
    }

    private static final void getConfigForPresence$lambda-9(PresenceSyncEngine this$0, PresenceConfig presenceConfig) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.config = presenceConfig;
        this$0.isConfigFetching = false;
        this$0.createPresenceSyncTimer();
    }

    private static final void getConfigForPresence$lambda-10(PresenceSyncEngine this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isConfigFetching = false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPresenceTimer$lambda-14$lambda-12(PresenceSyncEngine this$0, Long it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Set<String> set = this$0.syncedUserIdsMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"syncedUserIdsMap.keys");
        Set userIds = CollectionsKt.toMutableSet((Iterable)set);
        Collection<Set<String>> collection = this$0.syncedChannelUserIdsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"syncedChannelUserIdsMap.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void channelUserIds;
            Set set2 = (Set)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)channelUserIds, (String)"channelUserIds");
            collection2.add(userIds.addAll((Collection)channelUserIds));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this$0.fetchUserPresence(CollectionsKt.toList((Iterable)userIds));
        return Unit.INSTANCE;
    }

    private static final Unit createBufferTimer$lambda-15(PresenceSyncEngine this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.fetchBufferUserPresence();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void fetchUserPresence$lambda-20(PresenceSyncEngine this$0, List presences) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)presences, (String)"presences");
        this$0.emitPresencesToObserver(presences);
        Iterable $this$map$iv = presences;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void presence;
            AmityUserPresence amityUserPresence = (AmityUserPresence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ((Map)this$0.lastFetches).put(presence.getUserId(), DateTime.now());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private static final void fetchUserPresence$lambda-21(PresenceSyncEngine this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AmityLog.INSTANCE.tag(TAG).e("Error in fetching user presence: " + it, new Object[0]);
        this$0.syncingUserPresencePublisher.onNext((Object)CollectionsKt.emptyList());
        this$0.syncingChannelPresencePublisher.onNext((Object)CollectionsKt.emptyList());
    }

    private static final Boolean ensureChannelSyncLimit$lambda-30$lambda-29(PresenceSyncEngine this$0, String $channelId, List channelUserIds) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        Map map = this$0.syncedChannelUserIdsMap;
        Intrinsics.checkNotNullExpressionValue((Object)channelUserIds, (String)"channelUserIds");
        map.put($channelId, CollectionsKt.toSet((Iterable)channelUserIds));
        return this$0.userIdsBuffer.addAll(channelUserIds);
    }

    private static final void ensureChannelSyncLimit$lambda-30(PresenceSyncEngine this$0, String $channelId, String $viewId, Boolean isConversationChannel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        Intrinsics.checkNotNullParameter((Object)$viewId, (String)"$viewId");
        Intrinsics.checkNotNullExpressionValue((Object)isConversationChannel, (String)"isConversationChannel");
        if (isConversationChannel.booleanValue()) {
            Set set = this$0.syncedChannelIdsMap.get($channelId);
            Set viewIds = set == null ? (Set)new LinkedHashSet() : set;
            viewIds.add($viewId);
            ((Map)this$0.syncedChannelIdsMap).put($channelId, viewIds);
            this$0.getChannelUserIds($channelId).subscribeOn(Schedulers.io()).map(arg_0 -> PresenceSyncEngine.ensureChannelSyncLimit$lambda-30$lambda-29(this$0, $channelId, arg_0)).subscribe();
        } else {
            AmityLog.INSTANCE.tag(TAG).e("Conversation channel with given <" + $channelId + "> not found.", new Object[0]);
        }
    }

    private static final void ensureChannelSyncLimit$lambda-31(Throwable it) {
    }

    private static final Boolean checkChannelType$lambda-32(AmityChannel it) {
        return it.getChannelType() == AmityChannel.Type.CONVERSATION;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getChannelUserIds$lambda-34(List memberships) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)memberships, (String)"memberships");
        Iterable $this$map$iv = memberships;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityChannelMember amityChannelMember = (AmityChannelMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserId());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine$Companion;", "", "()V", "INITIAL_DELAY", "", "TAG", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

