/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.chat.domain.marker.message.SyncMarkedMessageUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.ReadSubChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.StartSubChannelReadingUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.StopSubChannelReadingUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.SubscribeToSubChannelMarkerTopicUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.UnsubscribeToSubChannelMarkerTopicUseCase;
import com.amity.socialcloud.sdk.core.MarkerEvent;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\u001a\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u000b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000bJ\b\u0010$\u001a\u00020\u0015H\u0002J\u001a\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u000b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000bJ\b\u0010&\u001a\u00020\u0015H\u0002J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014 \u0013*\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00120\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "isReadingMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "isReadyToRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "kotlin.jvm.PlatformType", "destroy", "", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getReadingSubChannelId", "", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "readSubChannels", "resumeReading", "startReading", "subChannelId", "channelId", "startTimer", "stopReading", "stopTimer", "syncReadAndDeliveredCount", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/MarkedMessageDto;", "timerDidTrigger", "Companion", "amity-sdk_release"})
public final class MarkReadEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Boolean> isReadingMap;
    @NotNull
    private final CompositeDisposable disposable;
    private final Completable timer;
    @NotNull
    private final AtomicBoolean isReadyToRead;
    private static final long SYNC_INTERVAL = 30L;

    public MarkReadEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.isReadingMap = new HashMap();
        this.disposable = new CompositeDisposable();
        this.timer = Flowable.interval((long)30L, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(arg_0 -> MarkReadEngine.timer$lambda-0(this, arg_0)).subscribeOn(Schedulers.io());
        this.isReadyToRead = new AtomicBoolean();
        this.isReadyToRead.set(false);
        MarkerEventBus.INSTANCE.observe().filter(MarkReadEngine::_init_$lambda-1).flatMapCompletable(arg_0 -> MarkReadEngine._init_$lambda-2(this, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable timerDidTrigger() {
        Completable completable = this.readSubChannels().onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"readSubChannels()\n\t\t\t\t.onErrorComplete()");
        return completable;
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @Nullable String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = Single.just((Object)subChannelId).flatMapCompletable(arg_0 -> MarkReadEngine.startReading$lambda-4(this, subChannelId, arg_0)).andThen((CompletableSource)new SubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId, channelId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"just(subChannelId)\n\t\t\t.f\u2026hannelId, channelId)\n\t\t\t)");
        return completable;
    }

    public static /* synthetic */ Completable startReading$default(MarkReadEngine markReadEngine, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return markReadEngine.startReading(string, string2);
    }

    private final Completable readSubChannels() {
        Completable completable;
        List<String> readingSubChannelIds = this.getReadingSubChannelId();
        if (readingSubChannelIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete()");
        } else {
            Completable completable3 = this.isReadyToRead.get() ? new ReadSubChannelUseCase().execute(readingSubChannelIds) : Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n\t\t\t\tif (isReadyToRead.\u2026ble.complete()\n\t\t\t\t}\n\t\t\t}");
        }
        return completable;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @Nullable String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        ((Map)this.isReadingMap).put(subChannelId, false);
        Completable completable = new StopSubChannelReadingUseCase().execute(subChannelId).andThen((CompletableSource)new UnsubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId, channelId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StopSubChannelReadingUse\u2026hannelId, channelId)\n\t\t\t)");
        return completable;
    }

    public static /* synthetic */ Completable stopReading$default(MarkReadEngine markReadEngine, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return markReadEngine.stopReading(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getReadingSubChannelId() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.isReadingMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private final Completable resumeReading() {
        return this.readSubChannels();
    }

    private final Completable syncReadAndDeliveredCount(MarkedMessageDto dto) {
        Completable completable = new SyncMarkedMessageUseCase().execute(dto).onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SyncMarkedMessageUseCase\u2026te(dto).onErrorComplete()");
        return completable;
    }

    private final void startTimer() {
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    private final void stopTimer() {
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.isReadyToRead.set(true);
        } else {
            this.isReadyToRead.set(false);
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToRead.set(true);
        this.startTimer();
    }

    @Override
    public void destroy() {
        this.isReadyToRead.set(false);
        this.stopTimer();
        this.isReadingMap.clear();
    }

    @Override
    public void handleTokenExpire() {
        this.isReadyToRead.set(false);
        this.stopTimer();
    }

    private static final CompletableSource timer$lambda-0(MarkReadEngine this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (CompletableSource)this$0.timerDidTrigger();
    }

    private static final boolean _init_$lambda-1(MarkerEvent it) {
        return it instanceof MarkerEvent.MarkedMessage || it instanceof MarkerEvent.NetworkConnection.Connected;
    }

    private static final CompletableSource _init_$lambda-2(MarkReadEngine this$0, MarkerEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MarkerEvent markerEvent = event;
        return markerEvent instanceof MarkerEvent.MarkedMessage ? (CompletableSource)this$0.syncReadAndDeliveredCount(((MarkerEvent.MarkedMessage)event).getDto()) : (markerEvent instanceof MarkerEvent.NetworkConnection.Connected ? (CompletableSource)this$0.resumeReading().onErrorComplete() : (CompletableSource)Completable.complete());
    }

    private static final void startReading$lambda-4$lambda-3(MarkReadEngine this$0, String $subChannelId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        ((Map)this$0.isReadingMap).put($subChannelId, false);
    }

    private static final CompletableSource startReading$lambda-4(MarkReadEngine this$0, String $subChannelId, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        ((Map)this$0.isReadingMap).put($subChannelId, true);
        return (CompletableSource)new StartSubChannelReadingUseCase().execute($subChannelId).doOnError(arg_0 -> MarkReadEngine.startReading$lambda-4$lambda-3(this$0, $subChannelId, arg_0));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkReadEngine$Companion;", "", "()V", "SYNC_INTERVAL", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

