/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.TombstoneDao;
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public final class TombstoneDao_Impl
extends TombstoneDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TombstoneEntity> __insertionAdapterOfTombstoneEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<TombstoneEntity> __deletionAdapterOfTombstoneEntity;
    private final EntityDeletionOrUpdateAdapter<TombstoneEntity> __updateAdapterOfTombstoneEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public TombstoneDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTombstoneEntity = new EntityInsertionAdapter<TombstoneEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `tombstone` (`objectId`,`errorCode`,`modelType`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TombstoneEntity value) {
                if (value.getObjectId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getObjectId());
                }
                stmt.bindLong(2, (long)value.getErrorCode());
                if (value.getModelType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getModelType());
                }
                String _tmp = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfTombstoneEntity = new EntityDeletionOrUpdateAdapter<TombstoneEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `tombstone` WHERE `objectId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TombstoneEntity value) {
                if (value.getObjectId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getObjectId());
                }
            }
        };
        this.__updateAdapterOfTombstoneEntity = new EntityDeletionOrUpdateAdapter<TombstoneEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `tombstone` SET `objectId` = ?,`errorCode` = ?,`modelType` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `objectId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TombstoneEntity value) {
                if (value.getObjectId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getObjectId());
                }
                stmt.bindLong(2, (long)value.getErrorCode());
                if (value.getModelType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getModelType());
                }
                String _tmp = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getObjectId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getObjectId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from tombstone";
                return "DELETE from tombstone";
            }
        };
    }

    @Override
    public void insertImpl(TombstoneEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTombstoneEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends TombstoneEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTombstoneEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(TombstoneEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfTombstoneEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends TombstoneEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfTombstoneEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(TombstoneEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfTombstoneEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(TombstoneEntity object) {
        this.__db.beginTransaction();
        try {
            TombstoneDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends TombstoneEntity> objects) {
        this.__db.beginTransaction();
        try {
            TombstoneDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(TombstoneEntity object) {
        this.__db.beginTransaction();
        try {
            TombstoneDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TombstoneEntity getTombstone(String objectId, String tombstoneModelType) {
        String _sql = "select * from tombstone where objectId = ? and modelType = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from tombstone where objectId = ? and modelType = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (objectId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, objectId);
        }
        _argIndex = 2;
        if (tombstoneModelType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tombstoneModelType);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            TombstoneEntity _result;
            int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"objectId");
            int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errorCode");
            int _cursorIndexOfModelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modelType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new TombstoneEntity();
                String _tmpObjectId = _cursor.isNull(_cursorIndexOfObjectId) ? null : _cursor.getString(_cursorIndexOfObjectId);
                _result.setObjectId(_tmpObjectId);
                int _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
                _result.setErrorCode(_tmpErrorCode);
                String _tmpModelType = _cursor.isNull(_cursorIndexOfModelType) ? null : _cursor.getString(_cursorIndexOfModelType);
                _result.setModelType(_tmpModelType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            TombstoneEntity tombstoneEntity = _result;
            return tombstoneEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

