/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.community;

import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategoryQuery;
import com.amity.socialcloud.sdk.api.social.community.create.AmityCommunityCreator;
import com.amity.socialcloud.sdk.api.social.community.notification.AmityCommunityNotification;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunityQuery;
import com.amity.socialcloud.sdk.api.social.community.update.AmityCommunityUpdate;
import com.amity.socialcloud.sdk.api.social.member.AmityCommunityModeration;
import com.amity.socialcloud.sdk.api.social.member.AmityCommunityParticipation;
import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.social.domain.category.get.CategoryLiveObjectUseCase;
import com.amity.socialcloud.sdk.social.domain.community.CommunityLiveObjectUseCase;
import com.amity.socialcloud.sdk.social.domain.community.DeleteCommunityUseCase;
import com.amity.socialcloud.sdk.social.domain.community.JoinCommunityUseCase;
import com.amity.socialcloud.sdk.social.domain.community.LeaveCommunityUseCase;
import com.amity.socialcloud.sdk.social.domain.community.RecommendedCommunityQueryUseCase;
import com.amity.socialcloud.sdk.social.domain.community.TrendingCommunityQueryUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\t\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00170\u000fJ\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00170\u000fJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\""}, d2={"Lcom/amity/socialcloud/sdk/api/social/community/AmityCommunityRepository;", "", "()V", "createCommunity", "Lcom/amity/socialcloud/sdk/api/social/community/create/AmityCommunityCreator$Builder;", "displayName", "", "deleteCommunity", "Lio/reactivex/rxjava3/core/Completable;", "communityId", "editCommunity", "Lcom/amity/socialcloud/sdk/api/social/community/update/AmityCommunityUpdate$Builder;", "getCategories", "Lcom/amity/socialcloud/sdk/api/social/category/query/AmityCommunityCategoryQuery$Builder;", "getCategory", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/category/AmityCommunityCategory;", "categoryId", "getCommunities", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunityQuery$Builder;", "getCommunity", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunity;", "getRecommendedCommunities", "", "getTrendingCommunities", "joinCommunity", "leaveCommunity", "membership", "Lcom/amity/socialcloud/sdk/api/social/member/AmityCommunityParticipation;", "moderation", "Lcom/amity/socialcloud/sdk/api/social/member/AmityCommunityModeration;", "notification", "Lcom/amity/socialcloud/sdk/api/social/community/notification/AmityCommunityNotification;", "updateCommunity", "amity-sdk_release"})
public final class AmityCommunityRepository {
    @NotNull
    public final AmityCommunityCreator.Builder createCommunity(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return new AmityCommunityCreator.Builder(displayName);
    }

    @NotNull
    public final AmityCommunityQuery.Builder getCommunities() {
        return new AmityCommunityQuery.Builder();
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getRecommendedCommunities() {
        return new RecommendedCommunityQueryUseCase().execute();
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getTrendingCommunities() {
        return new TrendingCommunityQueryUseCase().execute();
    }

    @NotNull
    public final AmityCommunityParticipation membership(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new AmityCommunityParticipation(communityId);
    }

    @NotNull
    public final Flowable<AmityCommunity> getCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new CommunityLiveObjectUseCase().execute(communityId);
    }

    @NotNull
    public final Flowable<AmityCommunityCategory> getCategory(@NotNull String categoryId) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        return new CategoryLiveObjectUseCase().execute(categoryId);
    }

    @NotNull
    public final AmityCommunityCategoryQuery.Builder getCategories() {
        return new AmityCommunityCategoryQuery.Builder();
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new DeleteCommunityUseCase().execute(communityId);
    }

    @NotNull
    public final AmityCommunityUpdate.Builder editCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new AmityCommunityUpdate.Builder(communityId);
    }

    @Deprecated(message="Use editCommunity(communityId: String) instead")
    @NotNull
    public final AmityCommunityUpdate.Builder updateCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return this.editCommunity(communityId);
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new JoinCommunityUseCase().execute(communityId);
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new LeaveCommunityUseCase().execute(communityId);
    }

    @NotNull
    public final AmityCommunityModeration moderation(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new AmityCommunityModeration(communityId);
    }

    @Deprecated(message="Use AmityCoreClient.notification.community(communityId: String) instead")
    @NotNull
    public final AmityCommunityNotification notification(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        return new AmityCommunityNotification(communityId);
    }
}

