/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.post;

import com.amity.socialcloud.sdk.api.social.AmitySocialClient;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQuery;
import com.amity.socialcloud.sdk.api.social.post.create.target.AmityPostCreationTarget;
import com.amity.socialcloud.sdk.api.social.post.query.AmityPostQueryTarget;
import com.amity.socialcloud.sdk.api.social.post.reaction.AmityPostReactionQuery;
import com.amity.socialcloud.sdk.api.social.post.review.AmityPostReviewer;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0015"}, d2={"Lcom/amity/socialcloud/sdk/api/social/post/AmityPostRepository;", "", "()V", "createPost", "Lcom/amity/socialcloud/sdk/api/social/post/create/target/AmityPostCreationTarget;", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQuery$Builder;", "postId", "", "getPost", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "getPosts", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityPostQueryTarget;", "getReactions", "Lcom/amity/socialcloud/sdk/api/social/post/reaction/AmityPostReactionQuery$Builder;", "hardDeletePost", "Lio/reactivex/rxjava3/core/Completable;", "reviewPost", "Lcom/amity/socialcloud/sdk/api/social/post/review/AmityPostReviewer;", "softDeletePost", "amity-sdk_release"})
public final class AmityPostRepository {
    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostLiveObjectUseCase().execute(postId);
    }

    @NotNull
    public final AmityPostQueryTarget getPosts() {
        return new AmityPostQueryTarget();
    }

    @NotNull
    public final AmityPostCreationTarget createPost() {
        return new AmityPostCreationTarget();
    }

    @NotNull
    public final Completable softDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, false);
    }

    @NotNull
    public final Completable hardDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, true);
    }

    @NotNull
    public final AmityPostReviewer reviewPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReviewer(postId);
    }

    @NotNull
    public final AmityPostReactionQuery.Builder getReactions(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReactionQuery.Builder(postId);
    }

    @NotNull
    public final AmityCommentQuery.Builder getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AmitySocialClient.INSTANCE.newCommentRepository().getComments().post(postId);
    }
}

