/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageTag;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoMessageDao
extends EkoObjectDao<EkoMessageEntity>
implements AmityPagingDao<EkoMessageEntity> {
    private final EkoMessageTagDao messageTagDao = UserDatabase.get().messageTagDao();

    EkoMessageDao() {
    }

    @Query(value="SELECT message.* from message where message.subChannelId = :subChannelId and message.isDeleted = case when :isDeleted is not null then :isDeleted else isDeleted end order by channelSegment DESC LIMIT 1")
    abstract Flowable<EkoMessageEntity> getLatestMessageImpl(String var1, Boolean var2);

    public Flowable<EkoMessageEntity> getLatestMessage(String channelId) {
        return this.getLatestMessageImpl(channelId, null);
    }

    public Flowable<EkoMessageEntity> getLatestMessage(String channelId, Boolean isDeleted) {
        return this.getLatestMessageImpl(channelId, isDeleted);
    }

    @Query(value="SELECT channelSegment from message where subChannelId = :subChannelId and syncState = 'synced' order by channelSegment DESC LIMIT 1")
    public abstract int getHighestSegment(String var1);

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'syncing'")
    public abstract void cleanUpSyncingStateOnStartup();

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'uploading'")
    public abstract void cleanUpUploadingStateOnStartup();

    @Query(value="UPDATE message set syncState = :state where messageId = :messageId")
    public abstract Completable updateSyncState(String var1, String var2);

    @Override
    @Query(value="DELETE from message")
    public abstract void deleteAll();

    @Query(value="DELETE from message where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from message where channelId = :channelId order by createdAt DESC LIMIT -1 OFFSET :offset")
    abstract List<EkoMessageEntity> getOldMessages(String var1, int var2);

    @Transaction
    public void retainLatestFromChannel(String channelId, int offset) {
        List<EkoMessageEntity> oldMessages = this.getOldMessages(channelId, offset);
        this.delete(oldMessages);
    }

    @Query(value="DELETE from message where messageId = :messageId")
    public abstract Completable hardDeleteMessage(String var1);

    @Query(value="DELETE from message where channelId = :channelId")
    public abstract void hardDeleteAllFromChannel(String var1);

    @Query(value="UPDATE message set isDeleted = 1, data = null where channelId = :channelId and userId = :userId")
    abstract void softDeleteFromChannelByUserIdImpl(String var1, String var2);

    @Transaction
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        this.softDeleteFromChannelByUserIdImpl(channelId, userId);
    }

    @Query(value="UPDATE message set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Override
    @Transaction
    public void insert(EkoMessageEntity message) {
        super.insert(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag.Companion.getFactory());
    }

    @Override
    @Transaction
    public void insert(List<? extends EkoMessageEntity> messages) {
        super.insert(messages);
        EkoTagDao.update(messages, this.messageTagDao, EkoMessageTag.Companion.getFactory());
    }

    @Override
    @Transaction
    public void update(EkoMessageEntity message) {
        super.update(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag.Companion.getFactory());
    }

    @Query(value="SELECT message.* from message where message.messageId = :messageId LIMIT 1")
    abstract Flowable<EkoMessageEntity> getByIdImpl(String var1);

    public Flowable<EkoMessageEntity> getById(String messageId) {
        return this.getByIdImpl(messageId);
    }

    @Query(value="SELECT message.* from message where message.uniqueId = :uniqueId LIMIT 1")
    abstract EkoMessageEntity getByIdNowImpl(String var1);

    @Override
    public EkoMessageEntity getByIdNow(@NonNull String uniqueId) {
        return this.getByIdNowImpl(uniqueId);
    }

    @Query(value="SELECT message.* from message where message.messageId = :messageId LIMIT 1")
    abstract EkoMessageEntity getByMessageIdNowImpl(String var1);

    public EkoMessageEntity getByMessageIdNow(@NonNull String messageId) {
        return this.getByMessageIdNowImpl(messageId);
    }

    @Query(value="SELECT message.* from message where message.uniqueId IN (:uniqueIds)")
    abstract List<EkoMessageEntity> getByIdsNowImpl(List<String> var1);

    @Override
    @NonNull
    public List<EkoMessageEntity> getByIdsNow(@NonNull List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Query(value="SELECT message.* from message where message.subChannelId = :subChannelId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isFilterByTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end and message.type IN (:type) order by case when :isSortedAsc = 1 then message.createdAt end asc, case when :isSortedAsc = 0 then message.createdAt end desc")
    abstract Flowable<List<EkoMessageEntity>> observeMessagesWithTypeImpl(String var1, boolean var2, String var3, boolean var4, String[] var5, String[] var6, Boolean var7, List<String> var8, Boolean var9);

    @Query(value="SELECT message.* from message where message.subChannelId = :subChannelId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isFilterByTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end order by case when :isSortedAsc = 1 then message.createdAt end asc, case when :isSortedAsc = 0 then message.createdAt end desc")
    abstract Flowable<List<EkoMessageEntity>> observeMessagesImpl(String var1, boolean var2, String var3, boolean var4, String[] var5, String[] var6, Boolean var7, Boolean var8);

    public Flowable<List<EkoMessageEntity>> observeMessages(String subChannelId, boolean isFilterByParentId, String parentId, AmityTags includingTags, AmityTags excludingTags, Boolean isDeleted, List<String> type, AmityMessageQuerySortOption sortOption) {
        if (type.isEmpty()) {
            return this.observeMessagesImpl(subChannelId, isFilterByParentId, parentId, !includingTags.isEmpty(), includingTags.toArray(new String[0]), excludingTags.toArray(new String[0]), isDeleted, sortOption == AmityMessageQuerySortOption.FIRST_CREATED);
        }
        return this.observeMessagesWithTypeImpl(subChannelId, isFilterByParentId, parentId, !includingTags.isEmpty(), includingTags.toArray(new String[0]), excludingTags.toArray(new String[0]), isDeleted, type, sortOption == AmityMessageQuerySortOption.FIRST_CREATED);
    }

    @Query(value="SELECT * from message where message.subChannelId = :subChannelId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isIncludingTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags)) else message.messageId is not null end and case when :isExcludingTags then message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) else message.messageId is not null end and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end and message.updatedAt > :now and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by message.updatedAt desc limit 1")
    abstract Flowable<EkoMessageEntity> getLatestMessageImpl(String var1, Boolean var2, String var3, boolean var4, String[] var5, boolean var6, String[] var7, Boolean var8, int var9, int var10, DateTime var11);

    @Query(value="SELECT * from message where message.subChannelId = :subChannelId and case when :isFilterByParentId and :parentId is not null then message.parentId = :parentId  when :isFilterByParentId and :parentId is null then message.parentId is null  else message.messageId is not null end and case when :isIncludingTags then message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags)) else message.messageId is not null end and case when :isExcludingTags then message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) else message.messageId is not null end and case when :isDeleted is not null then message.isDeleted = :isDeleted else message.messageId is not null end and message.updatedAt > :now and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) and message.type in (:type) order by message.updatedAt desc limit 1")
    abstract Flowable<EkoMessageEntity> getLatestMessageWithTypeImpl(String var1, Boolean var2, String var3, boolean var4, String[] var5, boolean var6, String[] var7, Boolean var8, List<String> var9, int var10, int var11, DateTime var12);

    public Flowable<EkoMessageEntity> getLatestMessage(String subChannelId, Boolean isFilterByParentId, String parentId, String[] includingTags, String[] excludingTags, Boolean isDeleted, List<String> type, int hash, int nonce, DateTime now) {
        if (type.isEmpty()) {
            return this.getLatestMessageImpl(subChannelId, isFilterByParentId, parentId, includingTags.length > 0, includingTags, excludingTags.length > 0, excludingTags, isDeleted, hash, nonce, now);
        }
        return this.getLatestMessageWithTypeImpl(subChannelId, isFilterByParentId, parentId, includingTags.length > 0, includingTags, excludingTags.length > 0, excludingTags, isDeleted, type, hash, nonce, now);
    }

    @Query(value="UPDATE message set messageMarkerHash = :hash where messageId = :messageId")
    public abstract void updateMarkerHash(String var1, int var2);
}

