/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core.file;

import android.net.Uri;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.core.domain.file.FileDeleteUseCase;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000e0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000e0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "", "()V", "cancelUpload", "", "uploadId", "", "deleteFile", "Lio/reactivex/rxjava3/core/Completable;", "fileId", "getUploadInfo", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadInfo;", "uploadAudio", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityAudio;", "uri", "Landroid/net/Uri;", "uploadFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFile;", "uploadImage", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "uploadVideo", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "contentFeedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "amity-sdk_release"})
public final class AmityFileRepository {
    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadFile(string, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadFile(uploadId, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadImage(string, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadImage(uploadId, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadAudio(string, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadAudio(uploadId, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadVideo(string, uri, contentFeedType);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        return new FileRepository().uploadVideo(uploadId, uri, contentFeedType);
    }

    public final void cancelUpload(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        new FileRepository().cancelUpload(uploadId);
    }

    @NotNull
    public final Flowable<AmityUploadInfo> getUploadInfo(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        return new FileRepository().getUploadInfo(uploadId);
    }

    @NotNull
    public final Completable deleteFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return new FileDeleteUseCase().execute(fileId);
    }
}

