/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Transaction;
import androidx.room.Update;
import com.ekoapp.ekosdk.EkoObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH'J\b\u0010\u000b\u001a\u00020\u0006H&J\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0014\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0017J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0015\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH'J\u0016\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0018\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "EntityType", "Lcom/ekoapp/ekosdk/EkoObject;", "", "()V", "delete", "", "object", "(Lcom/ekoapp/ekosdk/EkoObject;)V", "objects", "", "deleteAll", "getByIdNow", "id", "", "(Ljava/lang/String;)Lcom/ekoapp/ekosdk/EkoObject;", "getByIdsNow", "ids", "getExpiration", "Lorg/joda/time/Duration;", "insert", "insertImpl", "save", "freshList", "update", "updateImpl", "amity-sdk_release"})
public abstract class EkoObjectDao<EntityType extends EkoObject> {
    @Nullable
    public EntityType getByIdNow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s not implemented getByIdNow() yet.";
        Object[] objectArray = new Object[]{this.getClass().getName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String error = string2;
        throw (Throwable)new NotImplementedException(error);
    }

    @NotNull
    public List<EntityType> getByIdsNow(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return CollectionsKt.emptyList();
    }

    @Insert(onConflict=1)
    public abstract void insertImpl(@NotNull EntityType var1);

    @Insert(onConflict=1)
    public abstract void insertImpl(@NotNull List<? extends EntityType> var1);

    @Update
    public abstract void updateImpl(@NotNull EntityType var1);

    @Transaction
    public void insert(@NotNull EntityType object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.insertImpl(object);
    }

    @Deprecated(message="insert always replaces. use 'save()' as insertOrUpdate")
    @Transaction
    public void insert(@NotNull List<? extends EntityType> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        this.insertImpl(objects);
    }

    @Transaction
    public void update(@NotNull EntityType object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.updateImpl(object);
    }

    public void update(@NotNull List<? extends EntityType> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        for (EkoObject object : objects) {
            this.update(object);
        }
    }

    @Delete
    public abstract void delete(@NotNull EntityType var1);

    @Delete
    public abstract void delete(@NotNull List<? extends EntityType> var1);

    public abstract void deleteAll();

    @NotNull
    public Duration getExpiration() {
        Duration duration = Duration.standardMinutes((long)1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.standardMinutes(1)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public void save(@NotNull List<? extends EntityType> freshList) {
        void $this$associateByTo$iv$iv;
        String string;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(freshList, (String)"freshList");
        List<EntityType> fromNetwork = freshList;
        Iterable $this$map$iv = fromNetwork;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoObject ekoObject = (EkoObject)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            string = it.getId();
            object.add(string);
        }
        List idsFromNetwork = (List)destination$iv$iv;
        List<EntityType> onDisk = this.getByIdsNow(idsFromNetwork);
        Iterable $this$associateBy$iv = onDisk;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterator<EntityType> iterator = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            EkoObject ekoObject = (EkoObject)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getId(), (String)"it.id");
            object.put(string, element$iv$iv);
        }
        Map onDiskMap = destination$iv$iv2;
        $i$f$associateBy = false;
        List freshObjects = new ArrayList();
        capacity$iv = 0;
        List changedObjects = new ArrayList();
        for (EkoObject objectFromNetwork : fromNetwork) {
            boolean bl;
            String id = objectFromNetwork.getId();
            EkoObject objectOnDisk = (EkoObject)onDiskMap.get(id);
            DateTime expirationDateTime = DateTime.now().plus((ReadableDuration)this.getExpiration());
            if (!onDiskMap.containsKey(id)) {
                void $this$apply;
                Object element$iv$iv;
                element$iv$iv = objectFromNetwork;
                boolean bl2 = false;
                bl = false;
                Object object2 = element$iv$iv;
                object = freshObjects;
                boolean bl3 = false;
                $this$apply.setExpiresAt(expirationDateTime);
                string = Unit.INSTANCE;
                object.add(element$iv$iv);
                continue;
            }
            if (objectFromNetwork.getUpdatedAt() == null) continue;
            EkoObject ekoObject = objectOnDisk;
            if (!objectFromNetwork.getUpdatedAt().isAfter((ReadableInstant)(ekoObject != null ? ekoObject.getUpdatedAt() : null))) {
                EkoObject ekoObject2 = objectOnDisk;
                if (!objectFromNetwork.getUpdatedAt().isEqual((ReadableInstant)(ekoObject2 != null ? ekoObject2.getUpdatedAt() : null))) continue;
            }
            EkoObject ekoObject3 = objectFromNetwork;
            bl = false;
            boolean bl4 = false;
            EkoObject $this$apply = ekoObject3;
            boolean bl5 = false;
            $this$apply.setExpiresAt(expirationDateTime);
            EkoObject changedObject = ekoObject3;
            changedObjects.add(changedObject);
        }
        Collection collection = freshObjects;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.insert(freshObjects);
        }
        collection = changedObjects;
        bl = false;
        if (!collection.isEmpty()) {
            this.update(changedObjects);
        }
    }
}

