/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommunityMembershipDao_Impl
extends EkoCommunityMembershipDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityMembershipEntity> __insertionAdapterOfCommunityMembershipEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<CommunityMembershipEntity> __deletionAdapterOfCommunityMembershipEntity;
    private final EntityDeletionOrUpdateAdapter<CommunityMembershipEntity> __updateAdapterOfCommunityMembershipEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByCommunityIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserImpl;

    public EkoCommunityMembershipDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityMembershipEntity = new EntityInsertionAdapter<CommunityMembershipEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_membership` (`id`,`userId`,`communityId`,`channelId`,`metadata`,`communityMembership`,`isBanned`,`roles`,`permissions`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityMembershipEntity value) {
                Integer _tmp_1;
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCommunityId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                String _tmp = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                if (value.getCommunityMembership() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCommunityMembership());
                }
                Integer n = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
            }
        };
        this.__deletionAdapterOfCommunityMembershipEntity = new EntityDeletionOrUpdateAdapter<CommunityMembershipEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community_membership` WHERE `communityId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityMembershipEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfCommunityMembershipEntity = new EntityDeletionOrUpdateAdapter<CommunityMembershipEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community_membership` SET `id` = ?,`userId` = ?,`communityId` = ?,`channelId` = ?,`metadata` = ?,`communityMembership` = ?,`isBanned` = ?,`roles` = ?,`permissions` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `communityId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityMembershipEntity value) {
                Integer _tmp_1;
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCommunityId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                String _tmp = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                if (value.getCommunityMembership() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCommunityMembership());
                }
                Integer n = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getCommunityId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community_membership";
                return "DELETE from community_membership";
            }
        };
        this.__preparedStmtOfDeleteByCommunityIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community_membership where community_membership.communityId = ?";
                return "DELETE from community_membership where community_membership.communityId = ?";
            }
        };
        this.__preparedStmtOfUpdateUserImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_membership set userId = ? where userId = ?";
                return "UPDATE channel_membership set userId = ? where userId = ?";
            }
        };
    }

    @Override
    void insertImpl(CommunityMembershipEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityMembershipEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<CommunityMembershipEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityMembershipEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityMembershipEntity communityMembership) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityMembershipEntity.handle((Object)communityMembership);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<CommunityMembershipEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityMembershipEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(CommunityMembershipEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityMembershipEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteByCommunityId(String communityId) {
        this.__db.beginTransaction();
        try {
            EkoCommunityMembershipDao_Impl.super.deleteByCommunityId(communityId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(String userId) {
        this.__db.beginTransaction();
        try {
            EkoCommunityMembershipDao_Impl.super.updateUser(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityMembershipEntity membership) {
        this.__db.beginTransaction();
        try {
            EkoCommunityMembershipDao_Impl.super.insert(membership);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CommunityMembershipEntity> memberships) {
        this.__db.beginTransaction();
        try {
            EkoCommunityMembershipDao_Impl.super.insert(memberships);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByCommunityIdImpl(String communityId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByCommunityIdImpl.acquire();
        int _argIndex = 1;
        if (communityId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, communityId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByCommunityIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateUserImpl(String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserImpl.acquire();
        int _argIndex = 1;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommunityMembershipEntity getByCommunityIdAndUserIdNowImpl(String communityId, String userId) {
        String _sql = "SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CommunityMembershipEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfCommunityMembership = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityMembership");
            int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBanned");
            int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
            int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new CommunityMembershipEntity();
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                String _tmpCommunityMembership = _cursor.isNull(_cursorIndexOfCommunityMembership) ? null : _cursor.getString(_cursorIndexOfCommunityMembership);
                _result.setCommunityMembership(_tmpCommunityMembership);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsBanned));
                Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _result.setBanned(_tmpIsBanned);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                _result.setRoles(_tmpRoles);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                _result.setPermissions(_tmpPermissions);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            CommunityMembershipEntity communityMembershipEntity = _result;
            return communityMembershipEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommunityMembershipEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from community_membership where id = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_membership where id = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CommunityMembershipEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfCommunityMembership = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityMembership");
            int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBanned");
            int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
            int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new CommunityMembershipEntity();
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                String _tmpCommunityMembership = _cursor.isNull(_cursorIndexOfCommunityMembership) ? null : _cursor.getString(_cursorIndexOfCommunityMembership);
                _result.setCommunityMembership(_tmpCommunityMembership);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsBanned));
                Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _result.setBanned(_tmpIsBanned);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                _result.setRoles(_tmpRoles);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                _result.setPermissions(_tmpPermissions);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            CommunityMembershipEntity communityMembershipEntity = _result;
            return communityMembershipEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommunityMembershipEntity> getByIdImpl(String communityId, String userId) {
        String _sql = "SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_membership"}, (Callable)new Callable<CommunityMembershipEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityMembershipEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityMembershipDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommunityMembershipEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfCommunityMembership = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityMembership");
                    int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBanned");
                    int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityMembershipEntity();
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                        _result.setCommunityId(_tmpCommunityId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        String _tmpCommunityMembership = _cursor.isNull(_cursorIndexOfCommunityMembership) ? null : _cursor.getString(_cursorIndexOfCommunityMembership);
                        _result.setCommunityMembership(_tmpCommunityMembership);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsBanned));
                        Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        _result.setBanned(_tmpIsBanned);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                        _result.setRoles(_tmpRoles);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                        _result.setPermissions(_tmpPermissions);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    CommunityMembershipEntity communityMembershipEntity = _result;
                    return communityMembershipEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, CommunityMembershipEntity> getByMembershipsAndRolesImpl(String communityId, List<String> role, List<String> memberships, boolean isSortByCreatedACS, String queryRoles, String queryMemberships, String querySortOption) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community_membership, community_member_query_token where community_membership.communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_membership.communityMembership in (");
        int _inputSize = memberships.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and userId in (SELECT userId from community_role where communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and roleName in (");
        int _inputSize_1 = role.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) and (community_member_query_token.communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.roles = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.memberships = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.sortOption = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.pageNumber = 1 and community_member_query_token.ids like '%' || community_membership.id || '%') order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then community_membership.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then community_membership.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 8 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        for (String _item : memberships) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 3 + _inputSize;
        for (String _item_1 : role) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 3 + _inputSize + _inputSize_1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 4 + _inputSize + _inputSize_1;
        if (queryRoles == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, queryRoles);
        }
        _argIndex = 5 + _inputSize + _inputSize_1;
        if (queryMemberships == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, queryMemberships);
        }
        _argIndex = 6 + _inputSize + _inputSize_1;
        if (querySortOption == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, querySortOption);
        }
        _argIndex = 7 + _inputSize + _inputSize_1;
        int _tmp = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 8 + _inputSize + _inputSize_1;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        return new DataSource.Factory<Integer, CommunityMembershipEntity>(){

            public LimitOffsetDataSource<CommunityMembershipEntity> create() {
                return new LimitOffsetDataSource<CommunityMembershipEntity>(EkoCommunityMembershipDao_Impl.this.__db, _statement, false, true, new String[]{"community_membership", "community_member_query_token", "community_role"}){

                    protected List<CommunityMembershipEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityId");
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfCommunityMembership = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityMembership");
                        int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isBanned");
                        int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"permissions");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfCommunityId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityId");
                        int _cursorIndexOfRoles_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<CommunityMembershipEntity> _res = new ArrayList<CommunityMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityMembershipEntity _item_2 = new CommunityMembershipEntity();
                            String _tmpId = cursor.isNull(_cursorIndexOfId) ? null : cursor.getString(_cursorIndexOfId);
                            _item_2.setId(_tmpId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            String _tmpCommunityId = cursor.isNull(_cursorIndexOfCommunityId) ? null : cursor.getString(_cursorIndexOfCommunityId);
                            _item_2.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            _item_2.setMetadata(_tmpMetadata);
                            String _tmpCommunityMembership = cursor.isNull(_cursorIndexOfCommunityMembership) ? null : cursor.getString(_cursorIndexOfCommunityMembership);
                            _item_2.setCommunityMembership(_tmpCommunityMembership);
                            Integer _tmp_3 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
                            Boolean _tmpIsBanned = _tmp_3 == null ? null : Boolean.valueOf(_tmp_3 != 0);
                            _item_2.setBanned(_tmpIsBanned);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
                            AmityRoles _tmpRoles = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_4);
                            _item_2.setRoles(_tmpRoles);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
                            AmityPermissions _tmpPermissions = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_5);
                            _item_2.setPermissions(_tmpPermissions);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpCommunityId_1 = cursor.isNull(_cursorIndexOfCommunityId_1) ? null : cursor.getString(_cursorIndexOfCommunityId_1);
                            _item_2.setCommunityId(_tmpCommunityId_1);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfRoles_1) ? null : cursor.getString(_cursorIndexOfRoles_1);
                            AmityRoles _tmpRoles_1 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_8);
                            _item_2.setRoles(_tmpRoles_1);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item_2.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityMembershipEntity> getByMembershipsImpl(String communityId, List<String> memberships, boolean isSortByCreatedACS, String queryRoles, String queryMemberships, String querySortOption) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community_membership, community_member_query_token where community_membership.communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_membership.communityMembership in (");
        int _inputSize = memberships.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and (community_member_query_token.communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.roles = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.memberships = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.sortOption = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_member_query_token.pageNumber = 1 and community_member_query_token.ids like '%' || community_membership.id || '%') order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then community_membership.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then community_membership.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 7 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        for (String _item : memberships) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 3 + _inputSize;
        if (queryRoles == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, queryRoles);
        }
        _argIndex = 4 + _inputSize;
        if (queryMemberships == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, queryMemberships);
        }
        _argIndex = 5 + _inputSize;
        if (querySortOption == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, querySortOption);
        }
        _argIndex = 6 + _inputSize;
        int _tmp = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 7 + _inputSize;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        return new DataSource.Factory<Integer, CommunityMembershipEntity>(){

            public LimitOffsetDataSource<CommunityMembershipEntity> create() {
                return new LimitOffsetDataSource<CommunityMembershipEntity>(EkoCommunityMembershipDao_Impl.this.__db, _statement, false, true, new String[]{"community_membership", "community_member_query_token"}){

                    protected List<CommunityMembershipEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityId");
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfCommunityMembership = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityMembership");
                        int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isBanned");
                        int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"permissions");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfCommunityId_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"communityId");
                        int _cursorIndexOfRoles_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<CommunityMembershipEntity> _res = new ArrayList<CommunityMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityMembershipEntity _item_1 = new CommunityMembershipEntity();
                            String _tmpId = cursor.isNull(_cursorIndexOfId) ? null : cursor.getString(_cursorIndexOfId);
                            _item_1.setId(_tmpId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item_1.setUserId(_tmpUserId);
                            String _tmpCommunityId = cursor.isNull(_cursorIndexOfCommunityId) ? null : cursor.getString(_cursorIndexOfCommunityId);
                            _item_1.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_1.setChannelId(_tmpChannelId);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            _item_1.setMetadata(_tmpMetadata);
                            String _tmpCommunityMembership = cursor.isNull(_cursorIndexOfCommunityMembership) ? null : cursor.getString(_cursorIndexOfCommunityMembership);
                            _item_1.setCommunityMembership(_tmpCommunityMembership);
                            Integer _tmp_3 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
                            Boolean _tmpIsBanned = _tmp_3 == null ? null : Boolean.valueOf(_tmp_3 != 0);
                            _item_1.setBanned(_tmpIsBanned);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
                            AmityRoles _tmpRoles = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_4);
                            _item_1.setRoles(_tmpRoles);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
                            AmityPermissions _tmpPermissions = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_5);
                            _item_1.setPermissions(_tmpPermissions);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpCommunityId_1 = cursor.isNull(_cursorIndexOfCommunityId_1) ? null : cursor.getString(_cursorIndexOfCommunityId_1);
                            _item_1.setCommunityId(_tmpCommunityId_1);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfRoles_1) ? null : cursor.getString(_cursorIndexOfRoles_1);
                            AmityRoles _tmpRoles_1 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_8);
                            _item_1.setRoles(_tmpRoles_1);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item_1.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

