/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageQueryToken;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoMessageQueryTokenDao_Impl
extends EkoMessageQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoMessageQueryToken> __insertionAdapterOfEkoMessageQueryToken;
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public EkoMessageQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoMessageQueryToken = new EntityInsertionAdapter<EkoMessageQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message_query_token` (`channelId`,`parentId`,`includingTags`,`excludingTags`,`includingIsDeleted`,`isDeleted`,`isFilterByParentId`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageQueryToken value) {
                if (value.channelId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.channelId);
                }
                if (value.parentId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.parentId);
                }
                String _tmp = EkoMessageQueryTokenDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.includingTags);
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = EkoMessageQueryTokenDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.excludingTags);
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                int _tmp_2 = value.getIncludingIsDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_3);
                int _tmp_4 = value.isFilterByParentId() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_4);
                if (value.getPrevious() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getNext());
                }
                stmt.bindLong(10, (long)value.getPageNumber());
                String _tmp_5 = EkoMessageQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                String _tmp_6 = EkoMessageQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_6);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final EkoMessageQueryToken token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EkoMessageQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    EkoMessageQueryTokenDao_Impl.this.__insertionAdapterOfEkoMessageQueryToken.insert((Object)token);
                    EkoMessageQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoMessageQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<EkoMessageQueryToken> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<EkoMessageQueryToken>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    EkoMessageQueryToken _result = _cursor.moveToFirst() ? EkoMessageQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelEkoMessageQueryToken(_cursor) : null;
                    EkoMessageQueryToken ekoMessageQueryToken = _result;
                    return ekoMessageQueryToken;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private EkoMessageQueryToken __entityCursorConverter_comEkoappEkosdkInternalDataModelEkoMessageQueryToken(Cursor cursor) {
        int _cursorIndexOfChannelId = cursor.getColumnIndex("channelId");
        int _cursorIndexOfParentId = cursor.getColumnIndex("parentId");
        int _cursorIndexOfIncludingTags = cursor.getColumnIndex("includingTags");
        int _cursorIndexOfExcludingTags = cursor.getColumnIndex("excludingTags");
        int _cursorIndexOfIncludingIsDeleted = cursor.getColumnIndex("includingIsDeleted");
        int _cursorIndexOfIsDeleted = cursor.getColumnIndex("isDeleted");
        int _cursorIndexOfIsFilterByParentId = cursor.getColumnIndex("isFilterByParentId");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        EkoMessageQueryToken _entity = new EkoMessageQueryToken();
        if (_cursorIndexOfChannelId != -1) {
            _entity.channelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
        }
        if (_cursorIndexOfParentId != -1) {
            _entity.parentId = cursor.isNull(_cursorIndexOfParentId) ? null : cursor.getString(_cursorIndexOfParentId);
        }
        if (_cursorIndexOfIncludingTags != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfIncludingTags) ? null : cursor.getString(_cursorIndexOfIncludingTags);
            _entity.includingTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp);
        }
        if (_cursorIndexOfExcludingTags != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfExcludingTags) ? null : cursor.getString(_cursorIndexOfExcludingTags);
            _entity.excludingTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
        }
        if (_cursorIndexOfIncludingIsDeleted != -1) {
            int _tmp_2 = cursor.getInt(_cursorIndexOfIncludingIsDeleted);
            boolean _tmpIncludingIsDeleted = _tmp_2 != 0;
            _entity.setIncludingIsDeleted(_tmpIncludingIsDeleted);
        }
        if (_cursorIndexOfIsDeleted != -1) {
            int _tmp_3 = cursor.getInt(_cursorIndexOfIsDeleted);
            boolean _tmpIsDeleted = _tmp_3 != 0;
            _entity.setDeleted(_tmpIsDeleted);
        }
        if (_cursorIndexOfIsFilterByParentId != -1) {
            int _tmp_4 = cursor.getInt(_cursorIndexOfIsFilterByParentId);
            boolean _tmpIsFilterByParentId = _tmp_4 != 0;
            _entity.setFilterByParentId(_tmpIsFilterByParentId);
        }
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp_5 = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_5);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_6 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

