/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.channel;

import androidx.paging.DataSource;
import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagedList;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import androidx.paging.RemoteMediator;
import androidx.paging.rxjava2.PagingRx;
import co.amity.rxremotemediator.AmityQueryTokenDao;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembership;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.core.permission.ChannelMembership;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.ChannelAndMemberSingleConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelAddUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelRemoveUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStartReadingRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStopReadingRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoChannelMembershipBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipQueryTokenDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.ekoapp.ekosdk.internal.mapper.EkoChannelMapper;
import com.ekoapp.ekosdk.internal.repository.channel.ChannelMembershipRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.channel.ChannelParticipationRepository;
import com.ekoapp.ekosdk.internal.repository.channel.ChannelParticipationRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.channel.ChannelRepository;
import com.ekoapp.ekosdk.internal.repository.channel.SearchMembershipRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.channel.helper.AttachUserToChannelMembershipHelper;
import com.ekoapp.ekosdk.internal.repository.channel.helper.MapToEkoChannelMembershipModelHelper;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0000\u00a2\u0006\u0002\b\nJ2\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J4\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00160\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J)\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0000\u00a2\u0006\u0002\b J<\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00160\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\"0\t2\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u0007J\u0015\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b(\u00a8\u0006)"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/channel/ChannelParticipationRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addUsers", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannel;", "channelId", "", "userIds", "", "addUsers$amity_sdk_release", "getChannelMembershipPagedList", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMember;", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "filter", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembershipFilter;", "sortOption", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembershipSortOption;", "getChannelMembershipPagingData", "Landroidx/paging/PagingData;", "getFilters", "filters", "Lcom/amity/socialcloud/sdk/core/permission/ChannelMembership;", "getUser", "userId", "getUser$amity_sdk_release", "isMuted", "", "removeUsers", "removeUsers$amity_sdk_release", "searchChannelMembershipPagingData", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembership;", "keyword", "startReading", "", "startReading$amity_sdk_release", "stopReading", "stopReading$amity_sdk_release", "amity-sdk_release"})
public final class ChannelParticipationRepository
extends EkoObjectRepository {
    @NotNull
    public final Flowable<AmityChannelMember> getUser$amity_sdk_release(@NotNull String channelId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Flowable flowable = UserDatabase.get().channelMembershipDao().getByChannelIdAndUserId(channelId, userId).map((Function)getUser.1.INSTANCE).map((Function)getUser.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"UserDatabase.get().chann\u2026).apply(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityChannel> addUsers$amity_sdk_release(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        ChannelRepository channelRepository = new ChannelRepository();
        ChannelAddUsersRequest request = new ChannelAddUsersRequest(channelId, userIds);
        Function1 function1 = (Function1)new Function1<EkoChannelEntity, EkoChannelEntity>(channelRepository){

            @NotNull
            public final EkoChannelEntity invoke(@NotNull EkoChannelEntity p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ChannelRepository)this.receiver).attachDataToChannel(p1);
            }
        };
        ChannelParticipationRepository$sam$io_reactivex_functions_Function$0 channelParticipationRepository$sam$io_reactivex_functions_Function$0 = new ChannelParticipationRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoChannelEntity, AmityChannel>(channelRepository){

            @NotNull
            public final AmityChannel invoke(@NotNull EkoChannelEntity p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ChannelRepository)this.receiver).mapToExternalModel(p1);
            }
        };
        Single single = EkoSocket.call(Call.create(request, new ChannelAndMemberSingleConverter())).map((Function)channelParticipationRepository$sam$io_reactivex_functions_Function$0).map((Function)new ChannelParticipationRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026tory::mapToExternalModel)");
        return single;
    }

    @NotNull
    public final Single<AmityChannel> removeUsers$amity_sdk_release(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        ChannelRepository channelRepository = new ChannelRepository();
        ChannelRemoveUsersRequest request = new ChannelRemoveUsersRequest(channelId, userIds);
        Function1 function1 = (Function1)new Function1<EkoChannelEntity, EkoChannelEntity>(channelRepository){

            @NotNull
            public final EkoChannelEntity invoke(@NotNull EkoChannelEntity p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ChannelRepository)this.receiver).attachDataToChannel(p1);
            }
        };
        ChannelParticipationRepository$sam$io_reactivex_functions_Function$0 channelParticipationRepository$sam$io_reactivex_functions_Function$0 = new ChannelParticipationRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoChannelEntity, AmityChannel>(channelRepository){

            @NotNull
            public final AmityChannel invoke(@NotNull EkoChannelEntity p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ChannelRepository)this.receiver).mapToExternalModel(p1);
            }
        };
        Single single = EkoSocket.call(Call.create(request, new ChannelAndMemberSingleConverter())).map((Function)channelParticipationRepository$sam$io_reactivex_functions_Function$0).map((Function)new ChannelParticipationRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoSocket.call(Call.crea\u2026tory::mapToExternalModel)");
        return single;
    }

    public final void startReading$amity_sdk_release(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        EkoChannelDao channelDao = UserDatabase.get().channelDao();
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        Completable completable = Completable.fromAction((Action)new Action(channelDao, channelId, extraDao){
            final /* synthetic */ EkoChannelDao $channelDao;
            final /* synthetic */ String $channelId;
            final /* synthetic */ EkoChannelExtraDao $extraDao;

            public final void run() {
                AmityChannel channel;
                EkoChannelMapper ekoChannelMapper = new EkoChannelMapper();
                boolean bl = false;
                boolean bl2 = false;
                EkoChannelMapper $this$run = ekoChannelMapper;
                boolean bl3 = false;
                EkoChannelEntity ekoChannelEntity = this.$channelDao.getByIdNow(this.$channelId);
                AmityChannel amityChannel = channel = ekoChannelEntity != null ? $this$run.mapper(ekoChannelEntity) : null;
                int readToSegment = amityChannel != null ? amityChannel.getMessageCount() : 0;
                this.$extraDao.updateLocalReadToSegment(this.$channelId, readToSegment);
                this.$extraDao.updateReadStatus(this.$channelId, EkoChannelReadStatus.READING);
            }
            {
                this.$channelDao = ekoChannelDao;
                this.$channelId = string;
                this.$extraDao = ekoChannelExtraDao;
            }
        }).concatWith((CompletableSource)EkoSocket.rpc(new ChannelStartReadingRequest(channelId)).ignoreElement());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026nnelId)).ignoreElement())");
        Completable startReading2 = completable;
        extraDao.getById(channelId).firstElement().filter((Predicate)startReading.1.INSTANCE).flatMapCompletable((Function)new Function<EkoChannelExtra, CompletableSource>(startReading2){
            final /* synthetic */ Completable $startReading;

            public final CompletableSource apply(@NotNull EkoChannelExtra it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)this.$startReading;
            }
            {
                this.$startReading = completable;
            }
        }).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(channelId){
            final /* synthetic */ String $channelId;

            public final CompletableSource apply(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.USER_IS_BANNED == AmityError.Companion.from(it) ? (CompletableSource)new ChannelRepository().handleMembershipBanned(this.$channelId, AmityCoreClient.INSTANCE.getUserId()).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
            }
            {
                this.$channelId = string;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    public final void stopReading$amity_sdk_release(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        Completable completable = Completable.fromAction((Action)new Action(extraDao, channelId){
            final /* synthetic */ EkoChannelExtraDao $extraDao;
            final /* synthetic */ String $channelId;

            public final void run() {
                this.$extraDao.updateReadStatus(this.$channelId, EkoChannelReadStatus.NOT_READING);
            }
            {
                this.$extraDao = ekoChannelExtraDao;
                this.$channelId = string;
            }
        }).concatWith((CompletableSource)EkoSocket.rpc(new ChannelStopReadingRequest(channelId)).ignoreElement());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026nnelId)).ignoreElement())");
        Completable stopReading2 = completable;
        extraDao.getById(channelId).firstElement().filter((Predicate)stopReading.1.INSTANCE).flatMapCompletable((Function)new Function<EkoChannelExtra, CompletableSource>(stopReading2){
            final /* synthetic */ Completable $stopReading;

            public final CompletableSource apply(@NotNull EkoChannelExtra it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)this.$stopReading;
            }
            {
                this.$stopReading = completable;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @NotNull
    public final Flowable<PagedList<AmityChannelMember>> getChannelMembershipPagedList(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityChannelMembershipSortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        EkoChannelMembershipDao channelMembershipDao = UserDatabase.get().channelMembershipDao();
        DataSource.Factory<Integer, ChannelMembershipEntity> factory2 = channelMembershipDao.getDataSource(channelId, roles, filter.getMemberships(), filter.isMuted(), sortOption);
        int n = 15;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        AmityChannelMembershipSortOption amityChannelMembershipSortOption = sortOption;
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new AttachUserToChannelMembershipHelper()).map((androidx.arch.core.util.Function)new MapToEkoChannelMembershipModelHelper()), new EkoChannelMembershipBoundaryCallback(channelId, roles, amityChannelMembershipFilter, amityChannelMembershipSortOption, n));
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> getChannelMembershipPagingData(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityChannelMembershipSortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        PagingConfig pagingConfig = new PagingConfig(15, 0, false, 0, 0, 0, 58, null);
        String string = sortOption.getApiKey();
        EkoChannelMembershipQueryTokenDao ekoChannelMembershipQueryTokenDao = UserDatabase.get().channelMembershipQueryTokenDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelMembershipQueryTokenDao, (String)"UserDatabase.get().chann\u2026MembershipQueryTokenDao()");
        EkoChannelMembershipQueryTokenDao ekoChannelMembershipQueryTokenDao2 = ekoChannelMembershipQueryTokenDao;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        String string2 = string;
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new ChannelMembershipRxRemoteMediator(channelId, roles, amityChannelMembershipFilter, string2, ekoChannelMembershipQueryTokenDao2), (Function0)new Function0<PagingSource<Integer, ChannelMembershipEntity>>(channelId, roles, filter, sortOption){
            final /* synthetic */ String $channelId;
            final /* synthetic */ AmityRoles $roles;
            final /* synthetic */ AmityChannelMembershipFilter $filter;
            final /* synthetic */ AmityChannelMembershipSortOption $sortOption;

            @NotNull
            public final PagingSource<Integer, ChannelMembershipEntity> invoke() {
                EkoChannelMembershipDao channelMembershipDao = UserDatabase.get().channelMembershipDao();
                PagingSource<Integer, ChannelMembershipEntity> pagingSource = channelMembershipDao.getPagingSource(this.$channelId, this.$roles, this.$filter.getMemberships(), this.$filter.isMuted(), this.$sortOption);
                Intrinsics.checkNotNullExpressionValue(pagingSource, (String)"channelMembershipDao.get\u2026 sortOption\n            )");
                return pagingSource;
            }
            {
                this.$channelId = string;
                this.$roles = amityRoles;
                this.$filter = amityChannelMembershipFilter;
                this.$sortOption = amityChannelMembershipSortOption;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getChannelMembershipPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"pager.flowable\n         \u2026          }\n            }");
        return flowable;
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> searchChannelMembershipPagingData(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull List<? extends AmityChannelMembership> filters, @Nullable String keyword) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        PagingConfig pagingConfig = new PagingConfig(15, 0, false, 0, 0, 0, 58, null);
        AmityQueryTokenDao amityQueryTokenDao = UserDatabase.get().queryTokenDao();
        Intrinsics.checkNotNullExpressionValue((Object)amityQueryTokenDao, (String)"UserDatabase.get().queryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new SearchMembershipRxRemoteMediator(channelId, roles, filters, keyword, amityQueryTokenDao), (Function0)new Function0<PagingSource<Integer, ChannelMembershipEntity>>(channelId, roles, filters, keyword){
            final /* synthetic */ String $channelId;
            final /* synthetic */ AmityRoles $roles;
            final /* synthetic */ List $filters;
            final /* synthetic */ String $keyword;

            @NotNull
            public final PagingSource<Integer, ChannelMembershipEntity> invoke() {
                EkoChannelMembershipPagingDao channelMembershipDao = UserDatabase.get().channelMembersPagingDao();
                return channelMembershipDao.searchChannelMembership(this.$channelId, this.$roles, this.$filters, this.$keyword);
            }
            {
                this.$channelId = string;
                this.$roles = amityRoles;
                this.$filters = list;
                this.$keyword = string2;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)searchChannelMembershipPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"pager.flowable\n         \u2026          }\n            }");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getFilters(ChannelMembership filters) {
        void $this$mapTo$iv$iv;
        AmityChannelMembership it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = filters;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AmityChannelMembership)((Object)element$iv$iv);
            boolean bl = false;
            if (it == AmityChannelMembership.MUTED) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List channelFilter = (List)destination$iv$iv;
        Iterable $this$map$iv = new ChannelMembership(channelFilter);
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AmityChannelMembership)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getApiKey();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isMuted(ChannelMembership filters) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = filters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AmityChannelMembership it = (AmityChannelMembership)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == AmityChannelMembership.MUTED)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

