/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoMessageFlagDao_Impl
extends EkoMessageFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoMessageFlag> __insertionAdapterOfEkoMessageFlag;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoMessageFlag> __deletionAdapterOfEkoMessageFlag;
    private final EntityDeletionOrUpdateAdapter<EkoMessageFlag> __updateAdapterOfEkoMessageFlag;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoMessageFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoMessageFlag = new EntityInsertionAdapter<EkoMessageFlag>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message_flag` (`messageId`,`flag`,`localFlag`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageFlag value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                String _tmp = EkoMessageFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoMessageFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfEkoMessageFlag = new EntityDeletionOrUpdateAdapter<EkoMessageFlag>(__db){

            public String createQuery() {
                return "DELETE FROM `message_flag` WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageFlag value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
            }
        };
        this.__updateAdapterOfEkoMessageFlag = new EntityDeletionOrUpdateAdapter<EkoMessageFlag>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message_flag` SET `messageId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoMessageFlag value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                String _tmp = EkoMessageFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoMessageFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMessageId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_flag";
                return "DELETE from message_flag";
            }
        };
    }

    @Override
    void insertImpl(EkoMessageFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoMessageFlag.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoMessageFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoMessageFlag.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoMessageFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoMessageFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoMessageFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoMessageFlag.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoMessageFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoMessageFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoMessageFlag object) {
        this.__db.beginTransaction();
        try {
            EkoMessageFlagDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoMessageFlag> objects) {
        this.__db.beginTransaction();
        try {
            EkoMessageFlagDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoMessageFlag object) {
        this.__db.beginTransaction();
        try {
            EkoMessageFlagDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoMessageFlag getByIdNowImpl(String messageId) {
        String _sql = "SELECT * from message_flag where messageId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_flag where messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoMessageFlag _result;
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
            int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoMessageFlag();
                String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                _result.setMessageId(_tmpMessageId);
                String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                _result.setFlag(_tmpFlag);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                _result.setLocalFlag(_tmpLocalFlag);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoMessageFlag ekoMessageFlag = _result;
            return ekoMessageFlag;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoMessageFlag> getByMessageIdImpl(String messageId) {
        String _sql = "SELECT * from message_flag where message_flag.messageId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_flag where message_flag.messageId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message_flag"}, (Callable)new Callable<EkoMessageFlag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoMessageFlag call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoMessageFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoMessageFlag _result;
                    int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
                    int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
                    int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoMessageFlag();
                        String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                        EkoFlag _tmpFlag = EkoMessageFlagDao_Impl.this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                        _result.setFlag(_tmpFlag);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                        EkoLocalFlag _tmpLocalFlag = EkoMessageFlagDao_Impl.this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                        _result.setLocalFlag(_tmpLocalFlag);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoMessageFlag ekoMessageFlag = _result;
                    return ekoMessageFlag;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

