/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoChannelMembershipQueryFilterTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelMembershipQueryToken;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelMembershipQueryTokenDao_Impl
extends EkoChannelMembershipQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoChannelMembershipQueryToken> __insertionAdapterOfEkoChannelMembershipQueryToken;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoChannelMembershipQueryFilterTypeConverter __ekoChannelMembershipQueryFilterTypeConverter = new EkoChannelMembershipQueryFilterTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public EkoChannelMembershipQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelMembershipQueryToken = new EntityInsertionAdapter<EkoChannelMembershipQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_membership_query_token` (`channelId`,`roles`,`filter`,`sortBy`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelMembershipQueryToken value) {
                if (value.channelId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.channelId);
                }
                String _tmp = EkoChannelMembershipQueryTokenDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.roles);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoChannelMembershipQueryTokenDao_Impl.this.__ekoChannelMembershipQueryFilterTypeConverter.filterToApiKey(value.filter);
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.sortBy == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.sortBy);
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getNext());
                }
                stmt.bindLong(7, (long)value.getPageNumber());
                String _tmp_2 = EkoChannelMembershipQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final EkoChannelMembershipQueryToken token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EkoChannelMembershipQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    EkoChannelMembershipQueryTokenDao_Impl.this.__insertionAdapterOfEkoChannelMembershipQueryToken.insert((Object)token);
                    EkoChannelMembershipQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoChannelMembershipQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<EkoChannelMembershipQueryToken> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<EkoChannelMembershipQueryToken>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelMembershipQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelMembershipQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    EkoChannelMembershipQueryToken _result = _cursor.moveToFirst() ? EkoChannelMembershipQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelEkoChannelMembershipQueryToken(_cursor) : null;
                    EkoChannelMembershipQueryToken ekoChannelMembershipQueryToken = _result;
                    return ekoChannelMembershipQueryToken;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private EkoChannelMembershipQueryToken __entityCursorConverter_comEkoappEkosdkInternalDataModelEkoChannelMembershipQueryToken(Cursor cursor) {
        int _cursorIndexOfChannelId = cursor.getColumnIndex("channelId");
        int _cursorIndexOfRoles = cursor.getColumnIndex("roles");
        int _cursorIndexOfFilter = cursor.getColumnIndex("filter");
        int _cursorIndexOfSortBy = cursor.getColumnIndex("sortBy");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        EkoChannelMembershipQueryToken _entity = new EkoChannelMembershipQueryToken();
        if (_cursorIndexOfChannelId != -1) {
            _entity.channelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
        }
        if (_cursorIndexOfRoles != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
            _entity.roles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
        }
        if (_cursorIndexOfFilter != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfFilter) ? null : cursor.getString(_cursorIndexOfFilter);
            _entity.filter = this.__ekoChannelMembershipQueryFilterTypeConverter.apiKeyToFilter(_tmp_1);
        }
        if (_cursorIndexOfSortBy != -1) {
            _entity.sortBy = cursor.isNull(_cursorIndexOfSortBy) ? null : cursor.getString(_cursorIndexOfSortBy);
        }
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_2);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_3 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

