/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.RecommendedCommunityDao;
import com.ekoapp.ekosdk.internal.data.model.RecommendedCommunityEntity;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public final class RecommendedCommunityDao_Impl
extends RecommendedCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RecommendedCommunityEntity> __insertionAdapterOfRecommendedCommunityEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<RecommendedCommunityEntity> __deletionAdapterOfRecommendedCommunityEntity;
    private final EntityDeletionOrUpdateAdapter<RecommendedCommunityEntity> __updateAdapterOfRecommendedCommunityEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public RecommendedCommunityDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRecommendedCommunityEntity = new EntityInsertionAdapter<RecommendedCommunityEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `recommended_community` (`communityId`,`createdAt`,`updatedAt`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, RecommendedCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                String _tmp = RecommendedCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = RecommendedCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfRecommendedCommunityEntity = new EntityDeletionOrUpdateAdapter<RecommendedCommunityEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `recommended_community` WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RecommendedCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfRecommendedCommunityEntity = new EntityDeletionOrUpdateAdapter<RecommendedCommunityEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `recommended_community` SET `communityId` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RecommendedCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                String _tmp = RecommendedCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = RecommendedCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getCommunityId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from recommended_community";
                return "DELETE from recommended_community";
            }
        };
    }

    @Override
    void insertImpl(RecommendedCommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRecommendedCommunityEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<RecommendedCommunityEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRecommendedCommunityEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(RecommendedCommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRecommendedCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<RecommendedCommunityEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRecommendedCommunityEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(RecommendedCommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfRecommendedCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(RecommendedCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            RecommendedCommunityDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<RecommendedCommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            RecommendedCommunityDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(RecommendedCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            RecommendedCommunityDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RecommendedCommunityEntity getByIdNowImpl(String communityId) {
        String _sql = "SELECT * from recommended_community where communityId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from recommended_community where communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            RecommendedCommunityEntity _result;
            int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new RecommendedCommunityEntity();
                String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            RecommendedCommunityEntity recommendedCommunityEntity = _result;
            return recommendedCommunityEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

