/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.request.IsCommentFlaggedRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;

@Entity(tableName="comment_flag", primaryKeys={"commentId"}, foreignKeys={@ForeignKey(entity=CommentEntity.class, parentColumns={"commentId"}, childColumns={"commentId"}, onDelete=5)})
public class EkoCommentFlagEntity
extends EkoObject {
    @NonNull
    private String commentId;
    @SerializedName(value="hashFlag")
    private EkoFlag flag;
    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(@NonNull String commentId) {
        this.commentId = commentId;
    }

    public EkoFlag getFlag() {
        return this.flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return this.localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    public boolean isFlaggedByMe() {
        if (this.flag != null) {
            boolean mightFlaggedByMe = this.flag.mightFlaggedByMe();
            if (this.localFlag == null) {
                this.localFlag = new EkoLocalFlag();
            }
            if (mightFlaggedByMe && !Objects.equal((Object)this.flag.getHash(), (Object)this.localFlag.getSyncedUpHash())) {
                IsCommentFlaggedRequest request = new IsCommentFlaggedRequest(this.commentId);
                Single.just((Object)request).filter(this.flag::expired).flatMapSingle(EkoSocket::rpc).doOnSuccess(response -> {
                    this.localFlag.setFlaggedByMe(response.getData().get("result").getAsBoolean());
                    this.localFlag.setSyncedUpHash(this.flag.getHash());
                    UserDatabase.get().commentFlagDao().update(this);
                }).subscribe();
                return true;
            }
            return mightFlaggedByMe && this.localFlag.isFlaggedByMe();
        }
        if (this.localFlag != null) {
            Completable.fromAction(() -> {
                this.localFlag = null;
                UserDatabase.get().commentFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equal((Object)this.flag, (Object)((EkoCommentFlagEntity)obj).flag) && Objects.equal((Object)this.localFlag, (Object)((EkoCommentFlagEntity)obj).localFlag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.flag, this.localFlag});
    }
}

