/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.post.helper;

import androidx.annotation.WorkerThread;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.amity.socialcloud.sdk.social.feed.AmityPost;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.mapper.EkoPostMapper;
import com.ekoapp.ekosdk.internal.repository.comment.helper.CommentRepositoryHelper;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityMembershipRepositoryHelper;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityRepositoryHelper;
import com.ekoapp.ekosdk.internal.repository.post.helper.PostRepositoryHelper$WhenMappings;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/post/helper/PostRepositoryHelper;", "", "()V", "attachDataToEkoPost", "Lcom/ekoapp/ekosdk/internal/PostEntity;", "input", "mapToExternalModel", "Lcom/amity/socialcloud/sdk/social/feed/AmityPost;", "setChildren", "", "setFile", "setLatestComments", "setMyReactions", "setPostedUser", "setSharedUser", "setTarget", "amity-sdk_release"})
public final class PostRepositoryHelper {
    @WorkerThread
    @NotNull
    public final PostEntity attachDataToEkoPost(@NotNull PostEntity input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.setPostedUser(input);
        this.setSharedUser(input);
        this.setLatestComments(input);
        this.setChildren(input);
        this.setFile(input);
        this.setTarget(input);
        this.setMyReactions(input);
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private final void setMyReactions(PostEntity input) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        List<EkoReactionEntity> list = reactionDao.getAllMyReactionsByReferenceTypeAndReferenceIdNow(ReactionReferenceType.POST.getValue(), input.getPostId());
        Intrinsics.checkNotNullExpressionValue(list, (String)"reactionDao.getAllMyReac\u2026POST.value, input.postId)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoReactionEntity ekoReactionEntity = (EkoReactionEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string = v1.getReactionName();
            collection.add(string);
        }
        List list2 = (List)destination$iv$iv;
        input.setMyReactions(list2);
    }

    private final void setPostedUser(PostEntity input) {
        block0: {
            UserDao localUser = UserDatabase.get().userDao();
            UserEntity userEntity = localUser.getByIdNow(input.getPostedUserId());
            if (userEntity == null) break block0;
            UserEntity userEntity2 = userEntity;
            boolean bl = false;
            boolean bl2 = false;
            UserEntity user = userEntity2;
            boolean bl3 = false;
            new UserRepositoryHelper().attachDataAndMapToExternal(user);
            input.setPostedUser(user);
        }
    }

    private final void setSharedUser(PostEntity input) {
        block1: {
            UserDao localUser = UserDatabase.get().userDao();
            if (!input.isSharedPost()) break block1;
            UserEntity userEntity = localUser.getByIdNow(input.getSharedUserId());
            if (userEntity != null) {
                UserEntity userEntity2 = userEntity;
                boolean bl = false;
                boolean bl2 = false;
                UserEntity user = userEntity2;
                boolean bl3 = false;
                new UserRepositoryHelper().attachDataAndMapToExternal(user);
                input.setSharedUser(user);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setLatestComments(PostEntity input) {
        block2: {
            EkoCommentDao localComment = UserDatabase.get().commentDao();
            if (input.getCommentCount() <= 0) break block2;
            List<CommentEntity> list = localComment.getLatestComments(input.getPostId());
            if (list != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<CommentEntity> list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                List<CommentEntity> comments = list2;
                boolean bl3 = false;
                Iterable iterable = comments;
                CommentRepositoryHelper commentRepositoryHelper = new CommentRepositoryHelper();
                boolean $i$f$map = false;
                void var11_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    CommentEntity commentEntity = (CommentEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    CommentEntity commentEntity2 = commentRepositoryHelper.attachDataToEkoComment((CommentEntity)p1);
                    collection.add(commentEntity2);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                input.setLatestComments(comments);
            }
        }
    }

    private final void setFile(PostEntity input) {
        if (AmityPost.DataType.Companion.isAttachmentType(input.getPostDataType())) {
            EkoFileDao fileDao = UserDatabase.get().fileDao();
            AmityPost.DataType type = AmityPost.DataType.Companion.sealedOf(input.getPostDataType());
            JsonObject jsonObject = input.getData();
            EkoFileEntity file = fileDao.getByIdNow(jsonObject != null && (jsonObject = jsonObject.get(type.getFileIdKey())) != null ? jsonObject.getAsString() : null);
            if (file != null) {
                input.setFile(file);
            }
        }
    }

    private final void setTarget(PostEntity input) {
        switch (PostRepositoryHelper$WhenMappings.$EnumSwitchMapping$0[AmityPost.TargetType.Companion.enumOf(input.getTargetType()).ordinal()]) {
            case 1: {
                CommunityMembershipEntity postedMemberEntity;
                boolean bl;
                CommunityEntity communityEntity;
                EkoCommunityDao localCommunity = UserDatabase.get().communityDao();
                CommunityEntity communityEntity2 = communityEntity = localCommunity.getByIdNow(input.getTargetId());
                if (communityEntity2 != null) {
                    CommunityEntity communityEntity3 = communityEntity2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    CommunityEntity entity = communityEntity3;
                    bl = false;
                    CommunityRepositoryHelper.INSTANCE.attachDataToCommunity(entity);
                    input.setTargetCommunity(entity);
                }
                EkoCommunityMembershipDao communityMembershipDao = UserDatabase.get().communityMembershipDao();
                CommunityMembershipEntity communityMembershipEntity = postedMemberEntity = communityMembershipDao.getByCommunityIdAndUserIdNow(input.getTargetId(), input.getPostedUserId());
                if (communityMembershipEntity != null) {
                    CommunityMembershipEntity communityMembershipEntity2 = communityMembershipEntity;
                    boolean entity = false;
                    bl = false;
                    CommunityMembershipEntity entity2 = communityMembershipEntity2;
                    boolean bl4 = false;
                    CommunityMembershipRepositoryHelper.INSTANCE.attachDataToCommunityMembership(entity2);
                    input.setPostedMember(postedMemberEntity);
                }
                break;
            }
            case 2: {
                UserEntity internalUser;
                UserDao localUser = UserDatabase.get().userDao();
                UserEntity userEntity = internalUser = localUser.getByIdNow(input.getTargetId());
                if (userEntity != null) {
                    UserEntity userEntity2 = userEntity;
                    boolean bl = false;
                    boolean bl5 = false;
                    UserEntity user = userEntity2;
                    boolean bl6 = false;
                    new UserRepositoryHelper().attachDataAndMapToExternal(user);
                    input.setTargetUser(user);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setChildren(PostEntity input) {
        Collection collection = input.getChildPostIds();
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            void $this$mapTo$iv$iv;
            Object it;
            void $this$associateTo$iv$iv2;
            PostDao postDao = UserDatabase.get().postDao();
            List<PostEntity> list = postDao.getByIdsNow(input.getChildPostIds());
            bl2 = false;
            boolean bl3 = false;
            List<PostEntity> children = list;
            boolean bl4 = false;
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)input.getChildPostIds());
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                Map map = destination$iv$iv;
                it = (IndexedValue)element$iv$iv;
                boolean bl5 = false;
                it = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                bl5 = false;
                map.put(it.getFirst(), it.getSecond());
            }
            Map orderById = destination$iv$iv;
            List<PostEntity> list2 = children;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"children");
            Iterable $this$sortedBy$iv = list2;
            boolean $i$f$sortedBy = false;
            boolean $this$associateTo$iv$iv2 = false;
            List sortedPost = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(orderById){
                final /* synthetic */ Map $orderById$inlined;
                {
                    this.$orderById$inlined = map;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PostEntity it = (PostEntity)a;
                    boolean bl2 = false;
                    Comparable comparable = (Integer)this.$orderById$inlined.get(it.getPostId());
                    it = (PostEntity)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = (Integer)this.$orderById$inlined.get(it.getPostId());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            Iterable $this$map$iv = sortedPost;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PostEntity)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl6 = false;
                Object object = it;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                PostEntity postEntity = this.attachDataToEkoPost((PostEntity)object);
                collection2.add(postEntity);
            }
            List posts = (List)destination$iv$iv2;
            input.setChildren(posts);
        }
    }

    @WorkerThread
    @NotNull
    public final AmityPost mapToExternalModel(@NotNull PostEntity input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new EkoPostMapper().map(input);
    }
}

