/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.user.helper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserQueryDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceResponse;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserSingleMapper;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.repository.user.helper.RegisterDeviceManager;
import com.github.davidmoten.rx2.RetryWhen;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import retrofit2.Response;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0003J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/user/helper/RegisterDeviceManager;", "", "userId", "", "displayName", "authToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "cacheTimeDiff", "", "headers", "Lokhttp3/Headers;", "connect", "Lio/reactivex/Maybe;", "Lcom/ekoapp/ekosdk/internal/api/SocketConnectionEvent;", "disconnect", "register", "Lio/reactivex/Single;", "Lcom/ekoapp/ekosdk/internal/api/http/request/RegisterDeviceResponse;", "apiKey", "restart", "insertOrUpdate", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "response", "amity-sdk_release"})
public final class RegisterDeviceManager {
    private final String userId;
    private final String displayName;
    private final String authToken;

    @NotNull
    public final Single<RegisterDeviceResponse> register(@NotNull String apiKey) {
        EkoAccount account;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        EkoAccountDao accountDao = EkoDatabase.get().accountDao();
        EkoAccount ekoAccount = account = accountDao.activateAccount(this.userId);
        Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"account");
        RegisterDeviceRequest request = RegisterDeviceRequest.create(this.userId, this.displayName, ekoAccount.getDeviceId(), this.authToken);
        Single single = EkoApi.INSTANCE.auth().registerDevice(apiKey, request).flatMap((Function)new Function<Response<RegisterDeviceResponse>, SingleSource<? extends RegisterDeviceResponse>>(this){
            final /* synthetic */ RegisterDeviceManager this$0;

            public final SingleSource<? extends RegisterDeviceResponse> apply(@NotNull Response<RegisterDeviceResponse> it) {
                Single single;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (!it.isSuccessful()) {
                    JsonObject errorBody;
                    AmityException exception = null;
                    Gson gson = EkoGson.get();
                    Object object = it.errorBody();
                    if (object == null || (object = object.string()) == null) {
                        object = "{}";
                    }
                    JsonObject jsonObject = errorBody = (JsonObject)gson.fromJson((String)object, JsonObject.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"errorBody");
                    if (jsonObject.isJsonObject() && errorBody.has("code")) {
                        String code;
                        String string = errorBody.get("code").toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorBody.get(\"code\").toString()");
                        String string2 = code = string;
                        boolean bl = false;
                        AmityError error = AmityError.Companion.from(Integer.parseInt(string2));
                        exception = AmityException.Companion.create("", null, error);
                    } else {
                        exception = AmityException.Companion.create("", null, AmityError.UNKNOWN);
                    }
                    single = Single.error((Throwable)exception);
                } else {
                    Headers headers = it.headers();
                    Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"it.headers()");
                    RegisterDeviceManager.access$cacheTimeDiff(this.this$0, headers);
                    Object object = it.body();
                    Intrinsics.checkNotNull((Object)object);
                    single = Single.just((Object)object);
                }
                return (SingleSource)single;
            }
            {
                this.this$0 = registerDeviceManager;
            }
        }).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build()).doOnSuccess((Consumer)new Consumer<RegisterDeviceResponse>(this, account){
            final /* synthetic */ RegisterDeviceManager this$0;
            final /* synthetic */ EkoAccount $account;

            public final void accept(RegisterDeviceResponse it) {
                EkoAccount ekoAccount = this.$account;
                Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"account");
                RegisterDeviceResponse registerDeviceResponse = it;
                Intrinsics.checkNotNullExpressionValue((Object)registerDeviceResponse, (String)"it");
                RegisterDeviceManager.access$insertOrUpdate(this.this$0, ekoAccount, registerDeviceResponse);
            }
            {
                this.this$0 = registerDeviceManager;
                this.$account = ekoAccount;
            }
        }).doOnError((Consumer)register.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"EkoApi.auth()\n          \u2026oOnError { Timber.e(it) }");
        return single;
    }

    private final void cacheTimeDiff(Headers headers) {
        block0: {
            Date serverTime;
            Date date = serverTime = headers.getDate("date");
            if (date == null) break block0;
            Date date2 = date;
            boolean bl = false;
            boolean bl2 = false;
            Date it = date2;
            boolean bl3 = false;
            long l = it.getTime();
            DateTime dateTime = DateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"DateTime.now()");
            long diff = l - dateTime.getMillis();
            AmityCoreClient.INSTANCE.setMillisTimeDiff$amity_sdk_release((int)diff);
        }
    }

    private final void insertOrUpdate(EkoAccount $this$insertOrUpdate, RegisterDeviceResponse response) {
        $this$insertOrUpdate.setRefreshToken(response.getRefreshToken());
        $this$insertOrUpdate.setAccessToken(response.getAccessToken());
        EkoUserQueryDto dto = new EkoUserQueryDto();
        dto.setUsers(response.getUsers());
        dto.setFiles(response.getFiles());
        EkoUserSingleMapper.MAPPER.map(dto);
        EkoDatabase.get().accountDao().update($this$insertOrUpdate);
    }

    @NotNull
    public final Maybe<SocketConnectionEvent> restart() {
        Maybe maybe = this.disconnect().flatMap((Function)new Function<SocketConnectionEvent, MaybeSource<? extends SocketConnectionEvent>>(this){
            final /* synthetic */ RegisterDeviceManager this$0;

            public final MaybeSource<? extends SocketConnectionEvent> apply(@NotNull SocketConnectionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (MaybeSource)RegisterDeviceManager.access$connect(this.this$0);
            }
            {
                this.this$0 = registerDeviceManager;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)maybe, (String)"disconnect().flatMap { connect() }");
        return maybe;
    }

    private final Maybe<SocketConnectionEvent> disconnect() {
        Maybe maybe = EkoSocket.connectionEvent().filter((Predicate)disconnect.1.INSTANCE).firstElement();
        Intrinsics.checkNotNullExpressionValue((Object)maybe, (String)"EkoSocket.connectionEven\u2026          .firstElement()");
        return maybe;
    }

    private final Maybe<SocketConnectionEvent> connect() {
        Maybe maybe = EkoSocket.connectionEvent().filter((Predicate)connect.1.INSTANCE).firstElement();
        Intrinsics.checkNotNullExpressionValue((Object)maybe, (String)"EkoSocket.connectionEven\u2026          .firstElement()");
        return maybe;
    }

    public RegisterDeviceManager(@NotNull String userId, @Nullable String displayName, @Nullable String authToken) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.userId = userId;
        this.displayName = displayName;
        this.authToken = authToken;
    }

    public static final /* synthetic */ void access$cacheTimeDiff(RegisterDeviceManager $this, Headers headers) {
        $this.cacheTimeDiff(headers);
    }

    public static final /* synthetic */ void access$insertOrUpdate(RegisterDeviceManager $this, EkoAccount $this$access_u24insertOrUpdate, RegisterDeviceResponse response) {
        $this.insertOrUpdate($this$access_u24insertOrUpdate, response);
    }

    public static final /* synthetic */ Maybe access$connect(RegisterDeviceManager $this) {
        return $this.connect();
    }
}

