/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community.helper;

import androidx.annotation.WorkerThread;
import com.amity.socialcloud.sdk.social.community.AmityCommunity;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.mapper.EkoCommunityMapper;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityCategoryRepositoryHelper;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityRepositoryHelper;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0005H\u0003J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0005H\u0003J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0005H\u0003R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/helper/CommunityRepositoryHelper;", "", "()V", "factoryMapper", "Landroidx/arch/core/util/Function;", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunity;", "getFactoryMapper", "()Landroidx/arch/core/util/Function;", "queryMapper", "Lio/reactivex/functions/Function;", "getQueryMapper", "()Lio/reactivex/functions/Function;", "singleRequestMapper", "Lcom/ekoapp/ekosdk/internal/api/dto/CommunityListQueryDto;", "getSingleRequestMapper", "attachDataToCommunity", "entity", "mapToEkoCommunity", "setCategoriesToCommunity", "", "setFileToCommunity", "setUserToCommunity", "amity-sdk_release"})
public final class CommunityRepositoryHelper {
    @NotNull
    private static final androidx.arch.core.util.Function<CommunityEntity, AmityCommunity> factoryMapper;
    @NotNull
    private static final Function<CommunityEntity, AmityCommunity> queryMapper;
    @NotNull
    private static final Function<CommunityListQueryDto, AmityCommunity> singleRequestMapper;
    @NotNull
    public static final CommunityRepositoryHelper INSTANCE;

    @NotNull
    public final androidx.arch.core.util.Function<CommunityEntity, AmityCommunity> getFactoryMapper() {
        return factoryMapper;
    }

    @NotNull
    public final Function<CommunityEntity, AmityCommunity> getQueryMapper() {
        return queryMapper;
    }

    @NotNull
    public final Function<CommunityListQueryDto, AmityCommunity> getSingleRequestMapper() {
        return singleRequestMapper;
    }

    @WorkerThread
    @NotNull
    public final CommunityEntity attachDataToCommunity(@NotNull CommunityEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.setUserToCommunity(entity);
        this.setFileToCommunity(entity);
        this.setCategoriesToCommunity(entity);
        return entity;
    }

    @WorkerThread
    @NotNull
    public final AmityCommunity mapToEkoCommunity(@NotNull CommunityEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return new EkoCommunityMapper().map(entity);
    }

    @WorkerThread
    private final void setUserToCommunity(CommunityEntity entity) {
        block0: {
            UserEntity userEntity;
            UserDao userDao = UserDatabase.get().userDao();
            UserEntity userEntity2 = userEntity = userDao.getByIdNow(entity.getUserId());
            if (userEntity2 == null) break block0;
            UserEntity userEntity3 = userEntity2;
            boolean bl = false;
            boolean bl2 = false;
            UserEntity it = userEntity3;
            boolean bl3 = false;
            new UserRepositoryHelper().attachDataAndMapToExternal(it);
            entity.setUser(it);
        }
    }

    @WorkerThread
    private final void setFileToCommunity(CommunityEntity entity) {
        block0: {
            EkoFileDao fileDao = UserDatabase.get().fileDao();
            EkoFileEntity ekoFileEntity = fileDao.getByIdNow(entity.getAvatarFileId());
            if (ekoFileEntity == null) break block0;
            EkoFileEntity ekoFileEntity2 = ekoFileEntity;
            boolean bl = false;
            boolean bl2 = false;
            EkoFileEntity p1 = ekoFileEntity2;
            boolean bl3 = false;
            entity.setAvatarFile(p1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void setCategoriesToCommunity(CommunityEntity entity) {
        block1: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<CommunityCategoryEntity> categoryEntityList;
            EkoCommunityCategoryDao localCategory = UserDatabase.get().communityCategoryDao();
            List<CommunityCategoryEntity> list = categoryEntityList = localCategory.getByIdsNow(entity.getCategoryIds());
            if (list == null) break block1;
            List<CommunityCategoryEntity> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<CommunityCategoryEntity> list3 = list2;
            boolean bl3 = false;
            Iterable iterable = list3;
            CommunityCategoryRepositoryHelper communityCategoryRepositoryHelper = CommunityCategoryRepositoryHelper.INSTANCE;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                CommunityCategoryEntity communityCategoryEntity = (CommunityCategoryEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                CommunityCategoryEntity communityCategoryEntity2 = communityCategoryRepositoryHelper.attachDataToCommunityCategory((CommunityCategoryEntity)p1);
                collection.add(communityCategoryEntity2);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            entity.setCategories(list3);
        }
    }

    private CommunityRepositoryHelper() {
    }

    static {
        CommunityRepositoryHelper communityRepositoryHelper;
        INSTANCE = communityRepositoryHelper = new CommunityRepositoryHelper();
        factoryMapper = factoryMapper.1.INSTANCE;
        queryMapper = queryMapper.1.INSTANCE;
        singleRequestMapper = singleRequestMapper.1.INSTANCE;
    }
}

