/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipSortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityListQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddRoleRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityBanUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveRoleRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUnBanUsersRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityMembershipBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityMembershipRepositoryHelper;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ:\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a8\u0006\u001b"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityMembershipRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addRole", "Lio/reactivex/Completable;", "communityId", "", "role", "userIds", "", "addUsers", "banUsers", "users", "getCommunityMembershipCollection", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMember;", "roles", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipSortOption;", "getDefaultPageSize", "", "removeRole", "removeUsers", "unbanUsers", "amity-sdk_release"})
public final class CommunityMembershipRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunityMember>> getCommunityMembershipCollection(@NotNull String communityId, @Nullable List<String> roles, @NotNull AmityCommunityMembershipFilter filter, @NotNull AmityCommunityMembershipSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        EkoCommunityMembershipDao communityMembershipDao = UserDatabase.get().communityMembershipDao();
        DataSource.Factory<Integer, CommunityMembershipEntity> factory2 = communityMembershipDao.getMembers(communityId, roles, filter.getMemberships(), sortBy);
        EkoCommunityMembershipBoundaryCallback boundaryCallback = new EkoCommunityMembershipBoundaryCallback(communityId, filter.getMemberships(), roles, sortBy.getApiKey(), this.getDefaultPageSize());
        return this.createRxCollectionWithBoundaryCallback(factory2.map(CommunityMembershipRepositoryHelper.INSTANCE.getFactoryMapper()), boundaryCallback);
    }

    @NotNull
    public final Completable addUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityAddUsersRequest request = new CommunityAddUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityRemoveUsersRequest request = new CommunityRemoveUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable addRole(@NotNull String communityId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityAddRoleRequest request = new CommunityAddRoleRequest(communityId, role, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeRole(@NotNull String communityId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        CommunityRemoveRoleRequest request = new CommunityRemoveRoleRequest(communityId, role, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable banUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(users, (String)"users");
        CommunityBanUsersRequest request = new CommunityBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unbanUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(users, (String)"users");
        CommunityUnBanUsersRequest request = new CommunityUnBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }
}

