/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.request.IsPostFlaggedRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;

@Entity(tableName="post_flag", primaryKeys={"postId"}, foreignKeys={@ForeignKey(entity=PostEntity.class, parentColumns={"postId"}, childColumns={"postId"}, onDelete=5)})
public class EkoPostFlag
extends EkoObject {
    @NonNull
    private String postId;
    @SerializedName(value="hashFlag")
    private EkoFlag flag;
    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getPostId() {
        return this.postId;
    }

    public void setPostId(@NonNull String postId) {
        this.postId = postId;
    }

    public EkoFlag getFlag() {
        return this.flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return this.localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    public boolean isFlaggedByMe() {
        if (this.flag != null) {
            boolean mightFlaggedByMe = this.flag.mightFlaggedByMe();
            if (this.localFlag == null) {
                this.localFlag = new EkoLocalFlag();
            }
            if (mightFlaggedByMe && !Objects.equal((Object)this.flag.getHash(), (Object)this.localFlag.getSyncedUpHash())) {
                IsPostFlaggedRequest request = new IsPostFlaggedRequest(this.postId);
                Single.just((Object)request).filter(this.flag::expired).flatMapSingle(EkoSocket::rpc).doOnSuccess(response -> {
                    this.localFlag.setFlaggedByMe(response.getData().get("result").getAsBoolean());
                    this.localFlag.setSyncedUpHash(this.flag.getHash());
                    UserDatabase.get().postFlagDao().update(this);
                }).subscribe();
                return true;
            }
            return mightFlaggedByMe && this.localFlag.isFlaggedByMe();
        }
        if (this.localFlag != null) {
            Completable.fromAction(() -> {
                this.localFlag = null;
                UserDatabase.get().postFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equal((Object)this.flag, (Object)((EkoPostFlag)obj).flag) && Objects.equal((Object)this.localFlag, (Object)((EkoPostFlag)obj).localFlag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.flag, this.localFlag});
    }
}

