/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.internal.data.model.EkoPermissionObject;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName="community_permission", primaryKeys={"communityId", "userId", "permissionName"}, foreignKeys={@ForeignKey(entity=CommunityMembershipEntity.class, parentColumns={"communityId", "userId"}, childColumns={"communityId", "userId"}, onDelete=5)})
public class CommunityMembershipPermissionEntity
extends EkoPermissionObject {
    @NonNull
    private String communityId;
    @NonNull
    private String userId;
    @NonNull
    private String permissionName;

    @NonNull
    public String getCommunityId() {
        return this.communityId;
    }

    public void setCommunityId(@NonNull String communityId) {
        this.communityId = EkoPreconditions.checkValidId(communityId, "communityId");
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getPermissionName() {
        return this.permissionName;
    }

    public void setPermissionName(@NonNull String permissionName) {
        this.permissionName = EkoPreconditions.checkValidId(permissionName, "permissionName");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CommunityMembershipPermissionEntity other = (CommunityMembershipPermissionEntity)obj;
        return Objects.equal((Object)this.communityId, (Object)other.communityId) && Objects.equal((Object)this.userId, (Object)other.userId) && Objects.equal((Object)this.permissionName, (Object)other.permissionName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.communityId, this.userId, this.permissionName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("communityId", (Object)this.communityId).add("userId", (Object)this.userId).add("permissionName", (Object)this.permissionName).toString();
    }

    public static CommunityMembershipPermissionEntity create(@NonNull String communityId, @NonNull String userId, @NonNull String permissionName) {
        CommunityMembershipPermissionEntity communityPermission = new CommunityMembershipPermissionEntity();
        communityPermission.setCommunityId(communityId);
        communityPermission.setUserId(userId);
        communityPermission.setPermissionName(permissionName);
        return communityPermission;
    }
}

