/*
 * Decompiled with CFR 0.152.
 */
package org.bson.diagnostics;

import android.util.Log;
import org.bson.diagnostics.Logger;
import timber.log.Timber;

class TimberLogger
implements Logger {
    private static final String TIMBER_FORMAT = "%s";
    private final String name;

    TimberLogger(String name) {
        this.name = name;
    }

    private Timber.Tree timber() {
        return Timber.tag((String)this.name);
    }

    private boolean isLoggable(int level) {
        return Log.isLoggable((String)this.name, (int)level);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(2);
    }

    @Override
    public void trace(String msg) {
        this.timber().v(msg, new Object[0]);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.timber().v(t, TIMBER_FORMAT, new Object[]{msg});
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(3);
    }

    @Override
    public void debug(String msg) {
        this.timber().d(msg, new Object[0]);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.timber().d(t, TIMBER_FORMAT, new Object[]{msg});
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(4);
    }

    @Override
    public void info(String msg) {
        this.timber().i(msg, new Object[0]);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.timber().i(t, TIMBER_FORMAT, new Object[]{msg});
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(5);
    }

    @Override
    public void warn(String msg) {
        this.timber().w(msg, new Object[0]);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.timber().w(t, TIMBER_FORMAT, new Object[]{msg});
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(6);
    }

    @Override
    public void error(String msg) {
        this.timber().e(msg, new Object[0]);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.timber().e(t, TIMBER_FORMAT, new Object[]{msg});
    }
}

