/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoPostFlagDao_Impl
extends EkoPostFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoPostFlag> __insertionAdapterOfEkoPostFlag;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoPostFlag> __deletionAdapterOfEkoPostFlag;
    private final EntityDeletionOrUpdateAdapter<EkoPostFlag> __updateAdapterOfEkoPostFlag;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoPostFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoPostFlag = new EntityInsertionAdapter<EkoPostFlag>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `post_flag` (`postId`,`flag`,`localFlag`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoPostFlag value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                String _tmp = EkoPostFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoPostFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfEkoPostFlag = new EntityDeletionOrUpdateAdapter<EkoPostFlag>(__db){

            public String createQuery() {
                return "DELETE FROM `post_flag` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoPostFlag value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfEkoPostFlag = new EntityDeletionOrUpdateAdapter<EkoPostFlag>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `post_flag` SET `postId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoPostFlag value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                String _tmp = EkoPostFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoPostFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from post_flag";
                return "DELETE from post_flag";
            }
        };
    }

    @Override
    void insertImpl(EkoPostFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoPostFlag.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoPostFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoPostFlag.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoPostFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoPostFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoPostFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoPostFlag.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoPostFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoPostFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoPostFlag object) {
        this.__db.beginTransaction();
        try {
            EkoPostFlagDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoPostFlag> objects) {
        this.__db.beginTransaction();
        try {
            EkoPostFlagDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoPostFlag object) {
        this.__db.beginTransaction();
        try {
            EkoPostFlagDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoPostFlag getByIdNowImpl(String postId) {
        String _sql = "SELECT * from post_flag where postId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post_flag where postId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoPostFlag _result;
            int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
            int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
            int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoPostFlag();
                String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                _result.setPostId(_tmpPostId);
                String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                _result.setFlag(_tmpFlag);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                _result.setLocalFlag(_tmpLocalFlag);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoPostFlag ekoPostFlag = _result;
            return ekoPostFlag;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoPostFlag> getByPostIdImpl(String postId) {
        String _sql = "SELECT * from post_flag where post_flag.postId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post_flag where post_flag.postId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post_flag"}, (Callable)new Callable<EkoPostFlag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoPostFlag call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoPostFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoPostFlag _result;
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
                    int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoPostFlag();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _result.setPostId(_tmpPostId);
                        String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                        EkoFlag _tmpFlag = EkoPostFlagDao_Impl.this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                        _result.setFlag(_tmpFlag);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                        EkoLocalFlag _tmpLocalFlag = EkoPostFlagDao_Impl.this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                        _result.setLocalFlag(_tmpLocalFlag);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoPostFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoPostFlag ekoPostFlag = _result;
                    return ekoPostFlag;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

