/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.UserFeedQueryTokenEntity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/CommunityFeedQueryConverter;", "Lcom/ekoapp/ekosdk/internal/api/socket/call/ResponseConverter;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostQueryDto;", "keys", "", "", "", "(Ljava/util/Map;)V", "convert", "response", "Lcom/amity/socialcloud/sdk/socket/model/SocketResponse;", "invalidateCache", "", "dto", "amity-sdk_release"})
public final class CommunityFeedQueryConverter
implements ResponseConverter<EkoPostQueryDto> {
    private final Map<String, Object> keys;

    @Override
    @NotNull
    public EkoPostQueryDto convert(@NotNull SocketResponse response) {
        EkoPostQueryDto dto;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        EkoPostQueryDto ekoPostQueryDto = dto = (EkoPostQueryDto)response.getData(EkoPostQueryDto.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoPostQueryDto, (String)"dto");
        this.invalidateCache(ekoPostQueryDto);
        EkoPostAndUserMapper.MAPPER.map(dto);
        return dto;
    }

    private final void invalidateCache(EkoPostQueryDto dto) {
        UserFeedQueryTokenEntity userFeedQueryTokenEntity = dto.getPaging();
        Intrinsics.checkExpressionValueIsNotNull((Object)userFeedQueryTokenEntity, (String)"dto.paging");
        if (userFeedQueryTokenEntity.getPrevious() == null) {
            UserDatabase.get().communityFeedQueryTokenDao().deleteObsoleteQueryToken(this.keys, 0);
        }
    }

    public CommunityFeedQueryConverter(@NotNull Map<String, ? extends Object> keys) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        this.keys = keys;
    }
}

