/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.mqtt;

import android.util.Log;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.events.AmityTopic;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListener;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListeners;
import com.amity.socialcloud.sdk.infra.mqtt.payload.MqttPayload;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.JsonObject;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "addClientListeners", "", "authClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "autoSubscribe", "connect", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "createEventSubscription", "Lio/reactivex/disposables/Disposable;", "destroy", "disconnect", "Lio/reactivex/Completable;", "establish", "generateClientId", "", "newAccount", "handleTokenExpire", "initMqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "clientId", "username", "password", "", "obsoleteClient", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "AuthenticatedMqttClient", "Companion", "amity-sdk_release"})
public final class AmityMqttClient
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompositeDisposable subscriptions = new CompositeDisposable();
    @Nullable
    private static AuthenticatedMqttClient activeClient;
    @NotNull
    private static final String TAG;

    public AmityMqttClient(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        Log.e((String)"SSM3", (String)("mqtt session change: " + sessionState));
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Log.e((String)"SSM3", (String)("mqtt session establish: " + this.hashCode()));
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        if (authenticatedMqttClient != null) {
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it);
        }
        io.reactivex.rxjava3.core.Completable.fromAction(() -> AmityMqttClient.establish$lambda-1(this, account)).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void destroy() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it);
        }
    }

    @Override
    public void handleTokenExpire() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it);
        }
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (activeClient != null) {
            Completable completable2 = Completable.fromAction(() -> AmityMqttClient.disconnect$lambda-4(this));
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completabl\u2026tiveClient!!) }\n        }");
        } else {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n            Completable.complete()\n        }");
        }
        return completable;
    }

    private final void connect(EkoAccount account) {
        block6: {
            Mqtt3RxClient mqtt3RxClient;
            Object object;
            String clientId = this.generateClientId(account);
            UserDao userDao = UserDatabase.get().userDao();
            UserEntity user = userDao.getByIdNow(account.getUserId());
            if (user == null) {
                try {
                    UserRepository userRepository = new UserRepository();
                    String string = account.getUserId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
                    userRepository.fetchAndSave(string).blockingAwait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                user = userDao.getByIdNow(account.getUserId());
            }
            if ((object = user) == null || (object = ((UserEntity)object).getMid()) == null) {
                object = "";
            }
            Object username = object;
            String string = account.getAccessToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.accessToken");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] password = byArray;
            try {
                mqtt3RxClient = this.initMqttClient(clientId, (String)username, password);
            }
            catch (Exception e) {
                mqtt3RxClient = null;
            }
            Mqtt3RxClient mqttClient = mqtt3RxClient;
            Log.e((String)TAG, (String)("Connecting client: " + clientId + " userId: " + account.getUserId()));
            Mqtt3RxClient mqtt3RxClient2 = mqttClient;
            if (mqtt3RxClient2 == null) break block6;
            Mqtt3RxClient it = mqtt3RxClient2;
            boolean bl = false;
            ((Single)((Mqtt3ConnectBuilder.Nested)((Mqtt3ConnectBuilder.Nested)mqttClient.connectWith().cleanSession(false)).keepAlive(60)).applyConnect()).ignoreElement().doOnComplete(() -> AmityMqttClient.connect$lambda-7$lambda-5(clientId, account, mqttClient, this)).doOnError(AmityMqttClient::connect$lambda-7$lambda-6).subscribe();
        }
    }

    private final String generateClientId(EkoAccount newAccount) {
        String string = newAccount.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newAccount.deviceId");
        return string;
    }

    private final Mqtt3RxClient initMqttClient(String clientId, String username, byte[] password) {
        Mqtt3RxClient mqtt3RxClient = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)MqttClient.builder().useMqttVersion3().identifier(clientId)).serverHost(EkoEndpoint.INSTANCE.getMqttUrl())).serverPort(443)).sslWithDefaultConfig()).simpleAuth().username(username)).password(password)).applySimpleAuth()).automaticReconnectWithDefaultConfig()).addConnectedListener(AmityMqttClient::initMqttClient$lambda-8)).addDisconnectedListener(arg_0 -> AmityMqttClient.initMqttClient$lambda-9(clientId, arg_0))).buildRx();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3RxClient, (String)"builder()\n            .u\u2026 }\n            .buildRx()");
        return mqtt3RxClient;
    }

    private final void obsoleteClient(AuthenticatedMqttClient authClient) {
        subscriptions.clear();
        Log.e((String)TAG, (String)("Disconnecting client: \" + " + authClient.getClientId() + " + \" userId : \" + " + authClient.getAccount().getUserId()));
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        mqttClient.disconnect().subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnError(AmityMqttClient::obsoleteClient$lambda-10).subscribe();
        activeClient = null;
    }

    private final Disposable createEventSubscription(AuthenticatedMqttClient authClient) {
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        Disposable disposable = mqttClient.publishes(MqttGlobalPublishFilter.ALL).subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnNext(arg_0 -> AmityMqttClient.createEventSubscription$lambda-12(authClient, this, arg_0)).doOnError(AmityMqttClient::createEventSubscription$lambda-13).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"mqttClient\n            .\u2026\n            .subscribe()");
        return disposable;
    }

    private final void addClientListeners(AuthenticatedMqttClient authClient) {
        Disposable eventSubscription = this.createEventSubscription(authClient);
        subscriptions.add(eventSubscription);
    }

    private final void autoSubscribe() {
        Disposable networkSubscription = Companion.subscribe(new AmityTopic.NETWORK()).subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnError(AmityMqttClient::autoSubscribe$lambda-14).subscribe();
        subscriptions.add(networkSubscription);
    }

    private static final void establish$lambda-1(AmityMqttClient this$0, EkoAccount $account) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        this$0.connect($account);
    }

    private static final void disconnect$lambda-4(AmityMqttClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        Intrinsics.checkNotNull((Object)authenticatedMqttClient);
        this$0.obsoleteClient(authenticatedMqttClient);
    }

    private static final void connect$lambda-7$lambda-5(String $clientId, EkoAccount $account, Mqtt3RxClient $mqttClient, AmityMqttClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedMqttClient authClient = new AuthenticatedMqttClient($clientId, $account, $mqttClient);
        activeClient = authClient;
        this$0.addClientListeners(authClient);
        this$0.autoSubscribe();
    }

    private static final void connect$lambda-7$lambda-6(Throwable it) {
        Log.e((String)TAG, (String)("Connection exception: " + it.getMessage()));
    }

    private static final void initMqttClient$lambda-8(MqttClientConnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Log.e((String)TAG, (String)"mqtt connected");
    }

    private static final void initMqttClient$lambda-9(String $clientId, MqttClientDisconnectedContext it) {
        boolean shouldNotReconnect;
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Throwable throwable = it.getCause();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it.cause");
        Throwable exception = throwable;
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        boolean isNotActive = !Intrinsics.areEqual((Object)(authenticatedMqttClient != null ? authenticatedMqttClient.getClientId() : null), (Object)$clientId);
        boolean hasValidDisconnectReason = exception instanceof Mqtt3ConnAckException && (((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.IDENTIFIER_REJECTED || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.UNSUPPORTED_PROTOCOL_VERSION || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.BAD_USER_NAME_OR_PASSWORD || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.NOT_AUTHORIZED);
        boolean bl = shouldNotReconnect = isNotActive || hasValidDisconnectReason;
        if (shouldNotReconnect) {
            it.getReconnector().reconnect(false);
        }
        Log.e((String)TAG, (String)("mqtt disconnected || isNotActive: " + isNotActive + " || hasValidDisconnectReason: " + hasValidDisconnectReason + ' '));
        Log.e((String)TAG, (String)("mqtt disconnected || cause: " + exception));
    }

    private static final void obsoleteClient$lambda-10(Throwable it) {
        Log.e((String)TAG, (String)("Disconnect error: " + it.getMessage()));
    }

    private static final void createEventSubscription$lambda-12(AuthenticatedMqttClient $authClient, AmityMqttClient this$0, Mqtt3Publish it) {
        boolean isNotActiveClient;
        Intrinsics.checkNotNullParameter((Object)$authClient, (String)"$authClient");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        boolean bl = isNotActiveClient = !Intrinsics.areEqual((Object)$authClient.getClientId(), (Object)(authenticatedMqttClient != null ? authenticatedMqttClient.getClientId() : null));
        if (isNotActiveClient) {
            this$0.obsoleteClient($authClient);
            return;
        }
        try {
            byte[] byArray = it.getPayloadAsBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.payloadAsBytes");
            byte[] byArray2 = byArray;
            String payload = new String(byArray2, Charsets.UTF_8);
            Timber.tag((String)TAG).d("received event: " + payload, new Object[0]);
            MqttPayload event = (MqttPayload)EkoGson.get().fromJson(payload, MqttPayload.class);
            MqttEventListener<Object> listener = MqttEventListeners.INSTANCE.getMap().get(event.getEventType());
            if (listener != null) {
                JsonObject jsonObject = event.getData();
                if (jsonObject != null) {
                    JsonObject data = jsonObject;
                    boolean bl2 = false;
                    listener.onEvent$amity_sdk_release(data);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void createEventSubscription$lambda-13(Throwable it) {
    }

    private static final void autoSubscribe$lambda-14(Throwable it) {
        Timber.tag((String)TAG).e("Failed to subscribe network events", new Object[0]);
    }

    static {
        TAG = "AmityMqtt";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "", "clientId", "", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "mqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "(Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;)V", "getAccount", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getClientId", "()Ljava/lang/String;", "getMqttClient", "()Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class AuthenticatedMqttClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final EkoAccount account;
        @NotNull
        private final Mqtt3RxClient mqttClient;

        public AuthenticatedMqttClient(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            this.clientId = clientId;
            this.account = account;
            this.mqttClient = mqttClient;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount getAccount() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient getMqttClient() {
            return this.mqttClient;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount component2() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient component3() {
            return this.mqttClient;
        }

        @NotNull
        public final AuthenticatedMqttClient copy(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            return new AuthenticatedMqttClient(clientId, account, mqttClient);
        }

        public static /* synthetic */ AuthenticatedMqttClient copy$default(AuthenticatedMqttClient authenticatedMqttClient, String string, EkoAccount ekoAccount, Mqtt3RxClient mqtt3RxClient, int n, Object object) {
            if ((n & 1) != 0) {
                string = authenticatedMqttClient.clientId;
            }
            if ((n & 2) != 0) {
                ekoAccount = authenticatedMqttClient.account;
            }
            if ((n & 4) != 0) {
                mqtt3RxClient = authenticatedMqttClient.mqttClient;
            }
            return authenticatedMqttClient.copy(string, ekoAccount, mqtt3RxClient);
        }

        @NotNull
        public String toString() {
            return "AuthenticatedMqttClient(clientId=" + this.clientId + ", account=" + this.account + ", mqttClient=" + this.mqttClient + ')';
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.account.hashCode();
            result = result * 31 + this.mqttClient.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticatedMqttClient)) {
                return false;
            }
            AuthenticatedMqttClient authenticatedMqttClient = (AuthenticatedMqttClient)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)authenticatedMqttClient.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.account, (Object)authenticatedMqttClient.account)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mqttClient, (Object)authenticatedMqttClient.mqttClient);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "activeClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "getCurrentClient", "Lio/reactivex/Single;", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "subscribe", "Lio/reactivex/Completable;", "mqttTopic", "Lcom/amity/socialcloud/sdk/core/events/AmityTopic;", "unsubscribe", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final Completable subscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable(Companion::subscribe$lambda-3);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026      }\n                }");
            return completable;
        }

        @NotNull
        public final Completable unsubscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable(Companion::unsubscribe$lambda-5);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026      }\n                }");
            return completable;
        }

        private final Single<Mqtt3RxClient> getCurrentClient() {
            Single single;
            Mqtt3RxClient client;
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            Object object = client = authenticatedMqttClient != null ? authenticatedMqttClient.getMqttClient() : null;
            if (client == null) {
                AmityException exception = AmityException.Companion.create("Failed to subscribe", null, AmityError.UNKNOWN);
                Single single2 = Single.error((Throwable)exception);
                single = single2;
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"{\n                val ex\u2026(exception)\n            }");
            } else {
                Single single3 = Single.just((Object)client);
                single = single3;
                Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n                Single\u2026ust(client)\n            }");
            }
            return single;
        }

        private static final void subscribe$lambda-3$lambda-2$lambda-0(String $topic, Mqtt3SubAck it) {
            Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
            Timber.tag((String)Companion.getTAG()).d("Subscribed to " + $topic, new Object[0]);
        }

        private static final SingleSource subscribe$lambda-3$lambda-2$lambda-1(String $topic, Throwable it) {
            Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Timber.tag((String)Companion.getTAG()).e("Failed to subscribe " + $topic, new Object[0]);
            AmityException exception = AmityException.Companion.create("Failed to subscribe", null, AmityError.UNKNOWN);
            return (SingleSource)Single.error((Throwable)exception);
        }

        private static final CompletableSource subscribe$lambda-3$lambda-2(String $topic, Mqtt3RxClient client) {
            Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Mqtt3Subscribe mqtt3Subscribe = ((Mqtt3SubscribeBuilder.Start.Complete)((Mqtt3SubscribeBuilder.Start.Complete)Mqtt3Subscribe.builder().topicFilter($topic)).qos(MqttQos.AT_LEAST_ONCE)).build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3Subscribe, (String)"builder()\n              \u2026                 .build()");
            Mqtt3Subscribe subscribeMessage = mqtt3Subscribe;
            return (CompletableSource)client.subscribe(subscribeMessage).doOnSuccess(arg_0 -> Companion.subscribe$lambda-3$lambda-2$lambda-0($topic, arg_0)).onErrorResumeNext(arg_0 -> Companion.subscribe$lambda-3$lambda-2$lambda-1($topic, arg_0)).ignoreElement();
        }

        private static final CompletableSource subscribe$lambda-3(String topic) {
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            return (CompletableSource)Companion.getCurrentClient().flatMapCompletable(arg_0 -> Companion.subscribe$lambda-3$lambda-2(topic, arg_0));
        }

        private static final CompletableSource unsubscribe$lambda-5$lambda-4(String $topic, Mqtt3RxClient it) {
            Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Mqtt3Unsubscribe mqtt3Unsubscribe = ((Mqtt3UnsubscribeBuilder.Complete)Mqtt3Unsubscribe.builder().topicFilter($topic)).build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3Unsubscribe, (String)"builder()\n              \u2026                 .build()");
            Mqtt3Unsubscribe unsubscribeMessage = mqtt3Unsubscribe;
            return (CompletableSource)it.unsubscribe(unsubscribeMessage);
        }

        private static final CompletableSource unsubscribe$lambda-5(String topic) {
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            return (CompletableSource)Companion.getCurrentClient().flatMapCompletable(arg_0 -> Companion.unsubscribe$lambda-5$lambda-4(topic, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

