/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory;
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption;
import com.amity.socialcloud.sdk.social.data.category.CategoryQueryPersister;
import com.amity.socialcloud.sdk.social.data.category.CategoryRemoteDataStore;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryListDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCategoriesQueryRequest;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoBoundaryCallback;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003:\u0001&B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0002H\u0016J\b\u0010%\u001a\u00020\u001eH\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0014j\b\u0012\u0004\u0012\u00020\u000e`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommunityCategoryBoundaryCallback;", "Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoBoundaryCallback;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategory;", "Landroidx/arch/core/util/Function;", "sortOption", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategorySortOption;", "isDeleted", "", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "(Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategorySortOption;Ljava/lang/Boolean;ILio/reactivex/subjects/Subject;)V", "TAG", "", "kotlin.jvm.PlatformType", "categoryIdAndTokenMap", "", "Landroidx/core/util/Pair;", "categoryIdSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Ljava/lang/Boolean;", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/CommunityCategoriesQueryRequest$CommunityCategoriesQueryOptions;", "mapByCategory", "", "categoryId", "onFirstLoaded", "onItemAtEndLoaded", "itemAtEnd", "onItemAtFrontLoaded", "itemAtFront", "onZeroItemsLoaded", "Companion", "amity-sdk_release"})
public final class EkoCommunityCategoryBoundaryCallback
extends EkoBoundaryCallback<AmityCommunityCategory>
implements Function<AmityCommunityCategory, AmityCommunityCategory> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmityCommunityCategorySortOption sortOption;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final Subject<Boolean> delaySubject;
    private final String TAG;
    @NotNull
    private final Map<String, Pair<String, Boolean>> categoryIdAndTokenMap;
    @NotNull
    private final HashSet<String> categoryIdSet;
    @NotNull
    private static final Executor SINGLE_THREAD_EXECUTOR;

    public EkoCommunityCategoryBoundaryCallback(@NotNull AmityCommunityCategorySortOption sortOption, @Nullable Boolean isDeleted, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(delaySubject, (String)"delaySubject");
        super(pageSize);
        this.sortOption = sortOption;
        this.isDeleted = isDeleted;
        this.delaySubject = delaySubject;
        this.TAG = ((Object)((Object)this)).getClass().getName();
        this.categoryIdAndTokenMap = new LinkedHashMap();
        this.categoryIdSet = new HashSet();
        this.onFirstLoaded();
    }

    public void onItemAtFrontLoaded(@NotNull AmityCommunityCategory itemAtFront) {
        Intrinsics.checkNotNullParameter((Object)itemAtFront, (String)"itemAtFront");
    }

    public void onItemAtEndLoaded(@NotNull AmityCommunityCategory itemAtEnd) {
        Intrinsics.checkNotNullParameter((Object)itemAtEnd, (String)"itemAtEnd");
    }

    public void onZeroItemsLoaded() {
    }

    @Override
    public void onFirstLoaded() {
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        AmityLog.INSTANCE.tag(string).i("onFirstLoaded", new Object[0]);
        CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions options = new CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions(null, null, 3, null);
        options.setLimit(this.getPageSize());
        this.call(options).doOnComplete(() -> EkoCommunityCategoryBoundaryCallback.onFirstLoaded$lambda-0(this)).doOnError(arg_0 -> EkoCommunityCategoryBoundaryCallback.onFirstLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityCommunityCategory apply(@NotNull AmityCommunityCategory input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.categoryIdSet.add(input.getCategoryId());
        this.mapByCategory(input.getCategoryId());
        return input;
    }

    private final void mapByCategory(String categoryId) {
        block1: {
            Pair<String, Boolean> pair = this.categoryIdAndTokenMap.get(categoryId);
            if (pair == null) break block1;
            Pair<String, Boolean> categoryIdAndTokenMapNonNull = pair;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)categoryIdAndTokenMapNonNull.first;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)categoryIdAndTokenMapNonNull.second, (Object)true)) {
                return;
            }
            CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions options = new CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions(null, null, 3, null);
            options.setToken((String)categoryIdAndTokenMapNonNull.first);
            this.call(options).doOnSubscribe(arg_0 -> EkoCommunityCategoryBoundaryCallback.mapByCategory$lambda-4$lambda-2(this, categoryId, categoryIdAndTokenMapNonNull, arg_0)).doOnError(arg_0 -> EkoCommunityCategoryBoundaryCallback.mapByCategory$lambda-4$lambda-3(this, categoryId, categoryIdAndTokenMapNonNull, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    private final Completable call(CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions options) {
        Completable completable = RxJava3BridgeExtensionsKt.toV2(new CategoryRemoteDataStore().queryCategories(this.sortOption.getApiKey(), this.isDeleted, new QueryOptionsRequestParams(options.getLimit(), options.getToken()))).flatMap(EkoCommunityCategoryBoundaryCallback::call$lambda-5).doOnSuccess(arg_0 -> EkoCommunityCategoryBoundaryCallback.call$lambda-7(this, arg_0)).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action(arg_0 -> EkoCommunityCategoryBoundaryCallback.call$lambda-8(this, arg_0)).build()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CategoryRemoteDataStore(\u2026         .ignoreElement()");
        return completable;
    }

    private static final void onFirstLoaded$lambda-0(EkoCommunityCategoryBoundaryCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void onFirstLoaded$lambda-1(EkoCommunityCategoryBoundaryCallback this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void mapByCategory$lambda-4$lambda-2(EkoCommunityCategoryBoundaryCallback this$0, String $categoryId, Pair $categoryIdAndTokenMapNonNull, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$categoryId, (String)"$categoryId");
        Intrinsics.checkNotNullParameter((Object)$categoryIdAndTokenMapNonNull, (String)"$categoryIdAndTokenMapNonNull");
        this$0.categoryIdAndTokenMap.put($categoryId, (Pair<String, Boolean>)new Pair($categoryIdAndTokenMapNonNull.first, (Object)true));
    }

    private static final void mapByCategory$lambda-4$lambda-3(EkoCommunityCategoryBoundaryCallback this$0, String $categoryId, Pair $categoryIdAndTokenMapNonNull, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$categoryId, (String)"$categoryId");
        Intrinsics.checkNotNullParameter((Object)$categoryIdAndTokenMapNonNull, (String)"$categoryIdAndTokenMapNonNull");
        this$0.categoryIdAndTokenMap.put($categoryId, (Pair<String, Boolean>)new Pair($categoryIdAndTokenMapNonNull.first, (Object)false));
    }

    private static final SingleSource call$lambda-5(EkoCommunityCategoryListDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return (SingleSource)RxJava3BridgeExtensionsKt.toV2(new CategoryQueryPersister().persist(dto)).andThen((SingleSource)Single.just((Object)dto));
    }

    private static final void call$lambda-7(EkoCommunityCategoryBoundaryCallback this$0, EkoCommunityCategoryListDto dto) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        List<EkoCommunityCategoryDto> communityCategories = dto.getResults();
        Collection collection = communityCategories;
        if (!(collection == null || collection.isEmpty())) {
            EkoCommunityCategoryDto ekoCommunityCategoryDto;
            Object $this$lastOrNull$iv;
            block6: {
                Intrinsics.checkNotNullExpressionValue(communityCategories, (String)"communityCategories");
                $this$lastOrNull$iv = communityCategories;
                boolean $i$f$lastOrNull = false;
                ListIterator<EkoCommunityCategoryDto> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    EkoCommunityCategoryDto element$iv;
                    EkoCommunityCategoryDto it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(this$0.isDeleted == null ? true : Intrinsics.areEqual((Object)this$0.isDeleted, (Object)it.getDeleted()))) continue;
                    ekoCommunityCategoryDto = element$iv;
                    break block6;
                }
                ekoCommunityCategoryDto = null;
            }
            EkoCommunityCategoryDto ekoCommunityCategoryDto2 = ekoCommunityCategoryDto;
            String categoryId = ekoCommunityCategoryDto2 != null ? ekoCommunityCategoryDto2.getCategoryId() : null;
            String nextPage = dto.getToken().getNext();
            $this$lastOrNull$iv = nextPage;
            if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                $this$lastOrNull$iv = categoryId;
                if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                    $this$lastOrNull$iv = this$0.categoryIdAndTokenMap;
                    Pair pair = Pair.create((Object)nextPage, (Object)false);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(nextPage, false)");
                    Pair pair2 = pair;
                    $this$lastOrNull$iv.put((String)categoryId, (Pair<String, Boolean>)pair2);
                    if (this$0.categoryIdSet.contains(categoryId)) {
                        this$0.mapByCategory(categoryId);
                    }
                } else {
                    CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions options = new CommunityCategoriesQueryRequest.CommunityCategoriesQueryOptions(null, null, 3, null);
                    options.setToken(nextPage);
                    this$0.call(options).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this$0);
                }
            }
        }
    }

    private static final void call$lambda-8(EkoCommunityCategoryBoundaryCallback this$0, RetryWhen.ErrorAndDuration errorAndDuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)errorAndDuration, (String)"errorAndDuration");
        String string = this$0.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{errorAndDuration.durationMs()};
        AmityLog.INSTANCE.tag(string).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", objectArray);
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommunityCategoryBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

